<?php
/**
 * @file
 * HTML5 Video Player view.
 */

/**
 * HTML5 Video Player view.
 */
function spider_video_player_html5_view($playlist, $theme_id, $nodeid) {
  if (isset($_GET['playlist'])) {
    $playlist = check_plain($_GET['playlist']);
  }
  if (isset($_GET['theme'])) {
    $theme_id = check_plain($_GET['theme']);
    // If shared from embed.
    $share_url = url('spider_video_player/html5', array('query' => array('theme' => $theme_id, 'playlist' => $playlist), 'absolute' => TRUE));
    $nodeid = 0;
  }
  else {
    // if (arg(0) == 'node' && is_numeric(arg(1))) {
      // $nodeid = arg(1);
      // $share_url = url('node/' . $nodeid, array('query' => array('share' => '1'), 'absolute' => TRUE));
    // }
    // If shared from node_view.
    $share_url = url(current_path(), array('query' => array('share' => '1'), 'absolute' => TRUE));
  }
  $content = '';
  $theme = db_query("SELECT * FROM {spider_video_player_theme} WHERE id=:id", array(':id' => $theme_id))->fetchObject();
  if ($theme->appWidth != '') {
    $width = $theme->appWidth;
  }
  else {
    $width = '640';
  }
  if ($theme->appHeight != '') {
    $height = $theme->appHeight;
  }
  else {
    $height = '480';
  }
  if (isset($_GET['defaultAlbumId'])) {
    $album_id = check_plain($_GET['defaultAlbumId']);
  }
  else {
    $album_id = '';
  }
  if (isset($_GET['defaultTrackId'])) {
    $track_id = check_plain($_GET['defaultTrackId']);
  }
  else {
    $track_id = '';
  }
  $playlist_array = explode(',', $playlist);
  $lib_rows = $theme->libRows;
  $lib_cols = $theme->libCols;
  $cell_width = 100 / $lib_cols . '%';
  $cell_height = 100 / $lib_rows . '%';
  $k = $lib_rows * $lib_cols;
  if (isset($_GET['play'])) {
    $p = check_plain($_GET['play']);
  }
  else {
    $p = 0;
  }
  $display = 'style="width:100%; height:100%; border-collapse:collapse;"';
  $table_count = 1;
  $ctrls_stack = $theme->ctrlsStack;
  if ($theme->ctrlsPos == 2) {
    $ctrl_top = $theme->appHeight - 40 . 'px';
  }
  else {
    $ctrl_top = '-0px';
  }
  $content .= '
    <div id="spider_video_player_html5_' . $nodeid . '">
    <link href="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/css/spider_video_player_jquery-ui.css" rel="stylesheet" type="text/css"/>
    <script src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_jquery-1.7.1.js"></script>
    <script src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_jquery.transit.js"></script>
    <script src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_jquery-ui.min.js"></script>
    <script src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_swfobject.js"></script>
    <script>
        function flashShare_' . $nodeid . '(type, b, c) {
          var t = document.title;
          switch (type) {
            case "fb":
              window.open("http://www.facebook.com/sharer.php?u="+encodeURIComponent("' . $share_url . '&defaultAlbumId=" + b + "&defaultTrackId=" + c) + "&t=" + encodeURIComponent(t), "Facebook","menubar=1,resizable=1,width=350,height=250");
              break;
            case "g":
              window.open("http://plus.google.com/share?url=" + encodeURIComponent("' . $share_url . '&defaultAlbumId=" + b + "&defaultTrackId=" + c) + "&t=" + encodeURIComponent(t), "Google","menubar=1,resizable=1,width=350,height=250");
              break;
            case "tw":
              window.open("http://twitter.com/home/?status=" + encodeURIComponent("' . $share_url . '&defaultAlbumId=" + b + "&defaultTrackId=" + c), "Twitter","menubar=1,resizable=1,width=350,height=250");
              break;
          }
        }
      </script>
      <style>
      #global_body_' . $nodeid . ' table {
        border: 0;
        border-spacing: 1px;
        margin: 0;
        padding: 0;
      }
      #global_body_' . $nodeid . ' td {
        border: 0;
        margin: 0;
        padding: 0;
      }
      #global_body_' . $nodeid . ' tr {
        background-color: rgba(1, 1, 1, 0);
      }
      #main {
        min-height: 0px;
        padding: 0px;
      }
      .control_' . $nodeid . ' {
        background-color: rgba(' . HEXDEC(SUBSTR($theme->framesBgColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->framesBgColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->framesBgColor, 4, 2)) . ', ' . $theme->framesBgAlpha / 100 . ');
        height: 40px;
        position: absolute;
        top: ' . $ctrl_top . ';
        width: ' . $theme->appWidth . 'px;
        z-index: 7;
      }
      .progressBar_' . $nodeid . ' {
        border-bottom: 1px solid rgba(' . HEXDEC(SUBSTR($theme->slideColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->slideColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->slideColor, 4, 2)) . ', ' . $theme->framesBgAlpha / 100 . ');
        border-top: 1px solid rgba(' . HEXDEC(SUBSTR($theme->slideColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->slideColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->slideColor, 4, 2)) . ', ' . $theme->framesBgAlpha / 100 . ');
        cursor: pointer;
        height: 6px;
        position: relative;
        width: 100%;
        z-index: 5;
      }
      .timeBar_' . $nodeid . ' {
        background-color: #' . $theme->slideColor . ';
        left: 0;
        height: 100%;
        position: absolute;
        top: 0;
        width: 0;
        z-index: 5;
      }
      .bufferBar_' . $nodeid . ' {
        background-color: #' . $theme->slideColor . ';
        height: 100%;
        left: 0;
        opacity: 0.3;
        position: absolute;
        top: 0;
        width: 0;
      }
      .volumeBar_' . $nodeid . ' {
        background-color: rgba(' . HEXDEC(SUBSTR($theme->framesBgColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->framesBgColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->framesBgColor, 4, 2)) . ', ' . $theme->framesBgAlpha / 100 . ');
        // border: 1px solid rgba(' . HEXDEC(SUBSTR($theme->slideColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->slideColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->slideColor, 4, 2)) . ', ' . $theme->framesBgAlpha / 100 . ');
        height: 4px;
        overflow: hidden;
        position: relative;
        width: 0px;
      }
      .volume_' . $nodeid . ' {
        background-color: #' . $theme->slideColor . ';
        height: 100%;
        left: 0;
        position: absolute;
        top: 0;
        width: 0;
      }
      #kukla_' . $nodeid . ' {
        background-color: rgba(' . HEXDEC(SUBSTR($theme->framesBgColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->framesBgColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->framesBgColor, 4, 2)) . ', ' . $theme->framesBgAlpha / 100 . ');
        color: white;
        height: ' . $theme->appHeight . 'px;
        ' . (($theme->playlistPos == 1) ? 'position:absolute;float:left;' : 'position:relative;float:right;') . '
        width: 0px;
        z-index: 100;
      }
      .control_btns_' . $nodeid . ' {
        opacity: ' . $theme->ctrlsMainAlpha / 100 . ';
      }
    </style>
    <div id="global_body_' . $nodeid . '" style="width:' . $theme->appWidth . 'px;height:' . $theme->appHeight . 'px; position:relative;">
      <div id="video_div_' . $nodeid . '" style="display:' . (($theme->startWithLib == 1) ? 'none' : 'block') . ';width:' . $theme->appWidth . 'px;height:' . $theme->appHeight . 'px;background-color:#' . $theme->vidBgColor . '">
        <div id="kukla_' . $nodeid . '">
          <input type="hidden" value="0" id="track_list_' . $nodeid . '"/>
          <div style="height:90%">
            <div onmousedown="scrolltp2_' . $nodeid . '=setInterval(\'scrollTop2_' . $nodeid . '()\', 30)" onmouseup="clearInterval(scrolltp2_' . $nodeid . ')" style="overflow:hidden; text-align:center;width:' . $theme->playlistWidth . 'px; height:20px">
              <img src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/top.png" style="cursor:pointer;" id="button20_' . $nodeid . '"/>
            </div>
            <div style="height:' . ($theme->appHeight - 40) . 'px;overflow:hidden">';
  for ($i = 0; $i < count($playlist_array) - 1; $i++) {
    $play = db_query("SELECT * FROM {spider_video_player_playlist} WHERE id=:id", array(':id' => $playlist_array[$i]))->fetchObject();
    if (!$play) {
      continue;
    }
    $v_ids = explode(',', $play->videos);
    $vi_ids = substr($play->videos, 0, -1);
    if ($i != 0) {
      $content .= '
              <table id="track_list_' . $nodeid . '_' . $i . '" style="display:none;height:100%;width:100%;border-spacing:0px;border:none;border-collapse:inherit;">';
    }
    else {
      $content .= '
              <table id="track_list_' . $nodeid . '_' . $i . '"  style="display:block;height:100%;width:100%;border-spacing:0px;border:none;border-collapse:inherit;">';
    }
    $content .= '
                <tr>
                  <td  style="text-align:left;border:0px solid grey;width:100%;vertical-align:top;">
                    <div id="scroll_div2_' . $nodeid . '_' . $i . '" class="playlist_values_' . $nodeid . '" style="position:relative">';
    $jj = 0;
    for ($j = 0; $j < count($v_ids) - 1; $j++) {
      $vds = db_query("SELECT * FROM {spider_video_player_video} WHERE id=:id", array(':id' => $v_ids[$j]))->fetchObject();
      if (!$vds) {
        continue;
      }
      if ($vds->type == "http") {
        if ($vds->urlHtml5 != '') {
          $html5Url = $vds->urlHtml5;
        }
        else {
          $html5Url = $vds->url;
        }
        $vids_thumb = $vds->thumb;
        if ($vds->urlHdHtml5 != '') {
          $html5UrlHD = $vds->urlHdHtml5;
        }
        else {
          $html5UrlHD = $vds->urlHD;
        }
        $content .= ' <div id="thumb_' . $nodeid . '_' . $jj . '"  onclick="jQuery(\'#HD_on_' . $nodeid . '\').val(0);document.getElementById(\'videoID_' . $nodeid . '\').src=\'' . $html5Url . '\';play_' . $nodeid . '();vid_select_' . $nodeid . '(this);vid_num_' . $nodeid . '=' . $jj . ';jQuery(\'#_track\').val(' . $jj . ');jQuery(\'#playlist_table_' . $nodeid . '_' . $i . '\').find(\'.vid_title_' . $nodeid . '\')[' . $jj . '].click();" class="vid_thumb_' . $nodeid . '" style="color:#' . $theme->textColor . ';cursor:pointer;width:' . $theme->playlistWidth . 'px;text-align:center"  >';
        if ($vds->thumb) {
          $content .= ' <img src="' . $vids_thumb . '" width="90px" style="display:none;" />';
        }
        $content .= '   <p style="font-size:' . $theme->playlistTextSize . 'px;line-height:30px;cursor:pointer;margin:0;" >' . ($jj + 1) . '-' . $vds->title . '</p>
                      </div>';
        $content .= ' <input type="hidden" id="urlHD_' . $nodeid . '_' . $jj . '" value="' . $html5UrlHD . '" />';
        $content .= ' <input type="hidden" id="vid_type_' . $nodeid . '_' . $jj . '" value="' . $vds->type . '" />';
        $jj = $jj + 1;
      }
    }
    $content .= '   </div>
                  </td>
                </tr>
              </table>';
  }
  $content .= '
            </div>
            <div onmousedown="scrollBot2_' . $nodeid . '=setInterval(\'scrollBottom2_' . $nodeid . '()\', 30)" onmouseup="clearInterval(scrollBot2_' . $nodeid . ')" style="position:absolute;overflow:hidden; text-align:center;width:' . $theme->playlistWidth . 'px; height:20px">
              <img src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/bot.png" style="cursor:pointer;" id="button21_' . $nodeid . '"/>
            </div>
          </div>
        </div>
        <video style="position:absolute" ontimeupdate="timeUpdate_' . $nodeid . '()" ondurationchange="durationChange_' . $nodeid . '();" id="videoID_' . $nodeid . '" src="" width="' . $theme->appWidth . '" height="' . $theme->appHeight . '">
          <p>' . t('Your browser does not support the video tag.') . '</p>
        </video>
        <div class="control_' . $nodeid . '" id="control_' . $nodeid . '" style="display:none;overflow:hidden">';
  if ($theme->ctrlsPos == 2) {
    $content .= '
          <div class="progressBar_' . $nodeid . '">
            <div class="timeBar_' . $nodeid . '"></div>
            <div class="bufferBar_' . $nodeid . '"></div>
          </div>';
  }
  $ctrls = explode(',', $ctrls_stack);
  $y = 1;
  $content .= '
          <table width="' . $theme->appWidth . '" id="control_btns_' . $nodeid . '" style="border:none;border-collapse:inherit;">
            <tr>';
  for ($i = 0; $i < count($ctrls); $i++) {
    $ctrl = explode(':', $ctrls[$i]);
    if ($ctrl[1] == 1) {
      $content .= '
              <td style="border:none;">';
      if ($ctrl[0] == 'playPause') {
        $content .= '
                <img id="button' . $y . '_' . $nodeid . '"  class="btnPlay_' . $nodeid . '" style="vertical-align:middle;cursor:pointer;opacity:' . $theme->ctrlsMainAlpha / 100 . '" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/play.png" />
                <img id="button' . ($y + 1) . '_' . $nodeid . '" width="16"  class="btnPause_' . $nodeid . '" style="vertical-align:middle;display:none;cursor:pointer;opacity:' . $theme->ctrlsMainAlpha / 100 . '" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/pause.png" />';
        $y = $y + 2;
      }
      elseif ($ctrl[0] == '+') {
        $content .= '
                <span id="space_' . $nodeid . '" style="padding-left:' . (($theme->appWidth * 20) / 100) . 'px"></span>';
      }
      elseif ($ctrl[0] == 'time') {
        $content .= '
                <span style="color:#' . $theme->ctrlsMainColor . ';opacity:' . $theme->ctrlsMainAlpha / 100 . '" id="time_' . $nodeid . '">00:00 </span>
                <span style="color:#' . $theme->ctrlsMainColor . ';opacity:' . $theme->ctrlsMainAlpha / 100 . '">/</span>
                <span style="color:#' . $theme->ctrlsMainColor . ';opacity:' . $theme->ctrlsMainAlpha / 100 . '" id="duration_' . $nodeid . '">00:00</span>';
      }
      elseif ($ctrl[0] == 'vol') {
        $content .= '
                <table  id="volumeTD_' . $nodeid . '" style="border:none;border-collapse: inherit;">
                  <tr style="width:0;">
                    <td id="voulume_img_' . $nodeid . '" style="border:none;width:0;">
                      <img class="volume_png_' . $nodeid . '" style="vertical-align:middle;cursor:pointer;opacity:' . $theme->ctrlsMainAlpha / 100 . '" id="button' . $y . '_' . $nodeid . '" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/vol.png" />
                      <img class="volume_mute_png_' . $nodeid . '" style="vertical-align:middle;display:none;cursor:pointer;opacity:' . $theme->ctrlsMainAlpha / 100 . '" id="button' . ($y + 1) . '_' . $nodeid . '" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/mute.png" />
                    </td>
                    <td id="volumeTD2_' . $nodeid . '" style="width:0px !important;border:none;">
                      <span id="volumebar_player_' . $nodeid . '" class="volumeBar_' . $nodeid . '" style="vertical-align:middle;">
                        <span class="volume_' . $nodeid . '"></span>
                      </span>
                    </td>
                  </tr>
                </table>';
        $y = $y + 2;
      }
      elseif ($ctrl[0] == 'shuffle') {
        $content .= '
                <img id="button' . $y . '_' . $nodeid . '" class="shuffle_' . $nodeid . '" style="vertical-align:middle;cursor:pointer;opacity:' . $theme->ctrlsMainAlpha / 100 . '" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/shuffle.png" />
                <img id="button' . ($y + 1) . '_' . $nodeid . '" class="shuffle_' . $nodeid . '" style="vertical-align:middle;display:none;cursor:pointer;opacity:' . $theme->ctrlsMainAlpha / 100 . '" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/shuffleoff.png" />';
        $y = $y + 2;
      }
      elseif ($ctrl[0] == 'repeat') {
        $content .= '
                <img id="button' . $y . '_' . $nodeid . '" class="repeat_' . $nodeid . '" style="vertical-align:middle;cursor:pointer;opacity:' . $theme->ctrlsMainAlpha / 100 . '" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/repeat.png" />
                <img id="button' . ($y + 1) . '_' . $nodeid . '" class="repeat_' . $nodeid . '" style="vertical-align:middle;display:none;cursor:pointer;opacity:' . $theme->ctrlsMainAlpha / 100 . '" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/repeatOff.png" />
                <img id="button' . ($y + 2) . '_' . $nodeid . '" class="repeat_' . $nodeid . '" style="vertical-align:middle;display:none;cursor:pointer;opacity:' . $theme->ctrlsMainAlpha / 100 . '" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/repeatOne.png" />';
        $y = $y + 3;
      }
      else {
        $content .= '
                <img style="vertical-align:middle;cursor:pointer;opacity:' . $theme->ctrlsMainAlpha / 100 . '" id="button' . $y . '_' . $nodeid . '" class="' . $ctrl[0] . '_' . $nodeid . '" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/' . $ctrl[0] . '.png" />';
        $y = $y + 1;
      }
      $content .= '
              </td>';
    }
  }
  $content .= '
            </tr>
          </table>';
  if ($theme->ctrlsPos == 1) {
    $content .= '
          <div class="progressBar_' . $nodeid . '">
            <div class="timeBar_' . $nodeid . '"></div>
            <div class="bufferBar_' . $nodeid . '"></div>
          </div>';
  }
  $content .= '
        </div>
      </div>
      <div id="album_div_' . $nodeid . '" style="' . (($theme->startWithLib == 0) ? 'display:none;' : '') . ' background-color:#' . $theme->appBgColor . ';height:100%; overflow:hidden;position:relative;">
        <table width="100%" height="100%" style="border:none;border-collapse:inherit;">
          <tr id="tracklist_up_' . $nodeid . '" style="display:none">
            <td height="22px" colspan="2" style="text-align:right;border:none;">
              <div
                onmouseover="this.style.background=\'rgba(' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 4, 2)) . ',0.4)\'"
                onmouseout="this.style.background=\'none\'" id="scroll_' . $nodeid . '"
                style="overflow:hidden;width:50%;height:100%;text-align:center;float:right;cursor:pointer;"
                onmousedown="scrolltp_' . $nodeid . '=setInterval(\'scrollTop_' . $nodeid . '()\', 30)" onmouseup="clearInterval(scrolltp_' . $nodeid . ')">
                <img src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/top.png" style="cursor:pointer;" id="button25_' . $nodeid . '"/>
              </div>
            </td>
          </tr>
          <tr>
            <td style="vertical-align:middle;border:none;">
              <img src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/prev.png" style="cursor:pointer;" id="button28_' . $nodeid . '" onclick="prevPage_' . $nodeid . '();"/>
            </td>
            <td style="width: 100%;border:none;">';
  for ($l = 0; $l < $table_count; $l++) {
    $content .= '
              <table id="lib_table_' . $nodeid . '_' . $l . '" ' . $display . '>';
    for ($i = 0; $i < $lib_rows; $i++) {
      $content .= '
                <tr>';
      for ($j = 0; $j < $lib_cols; $j++) {
        if ($p < (count($playlist_array) - 1)) {
          $play = db_query("SELECT * FROM {spider_video_player_playlist} WHERE id=:id", array(':id' => $playlist_array[$p]))->fetchObject();
          if (!$play) {
            $p = $p + 1;
            continue;
          }
          $play_thumb = $play->thumb;
          $content .= '
                  <td class="playlist_td_' . $nodeid . '" id="playlist_' . $nodeid . '_' . $p . '" onclick="openPlaylist_' . $nodeid . '(' . $p . ',' . $l . ')" onmouseover="this.style.color=\'#' . $theme->textHoverColor . '\';this.style.background=\'rgba(' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 0, 2)) . ',' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 2, 2)) . ',' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 4, 2)) . ',0.4)\'" onmouseout="this.style.color=\'#' . $theme->textColor . '\';this.style.background=\' none\'" style="color:#' . $theme->textColor . ';border:1px solid white;vertical-align:center; text-align:center;width:' . $cell_width . ';height:' . $cell_height . ';cursor:pointer">
                    ' . (($play->thumb != '') ? '<img src="' . $play_thumb . '" width="50%" />' : '') . '
                    <p style="font-size:' . $theme->libListTextSize . 'px">' . $play->title . '</p>
                  </td>';
          $p = $p + 1;
        }
        else {
          $content .= '
                  <td style="border:1px solid white;vertical-align:top; align:center;width:' . $cell_width . ';height:' . $cell_height . '">
                  </td>';
        }
      }
      $content .= '
                </tr>';
    }
    if ($p < (count($playlist_array) - 1)) {
      $table_count = $table_count + 1;
      $display = 'style="display:none;width:100%;height:100%;border-collapse:collapse;"';
    }
    $content .= '
              </table>';
  }
  for ($i = 0; $i < $p; $i++) {
    $play = db_query("SELECT * FROM {spider_video_player_playlist} WHERE id=:id", array(':id' => $playlist_array[$i]))->fetchObject();
    if (!$play) {
      continue;
    }
    $v_ids = explode(',', $play->videos);
    $vi_ids = substr($play->videos, 0, -1);
    $play_thumb = $play->thumb;
    $content .= '
              <table playlist_id="' . $i . '" id="playlist_table_' . $nodeid . '_' . $i . '" style="border:none;border-collapse:inherit;display:none;height:100%;width:100%">
                <tr>
                  <td style="text-align:center;vertical-align:top;border:none;">
                    ' . (($play->thumb != '') ? '<img src="' . $play_thumb . '" width="70%" /><br /><br />' : '') . '
                    <p style="color:#' . $theme->textColor . ';font-size:' . $theme->libDetailsTextSize . 'px;">' . $play->title . '</p>
                  </td>
                  <td style="width:50%;border:none;">
                    <div style="width:100%;text-align:left;border:1px solid white;height:' . ($theme->appHeight - 55) . 'px;vertical-align:top;position:relative;overflow:hidden">
                      <div id="scroll_div_' . $nodeid . '_' . $i . '" style="position:relative;">';
    $jj = 0;
    for ($j = 0; $j < count($v_ids) - 1; $j++) {
      $vds = db_query("SELECT * FROM {spider_video_player_video} WHERE id=:id", array(':id' => $v_ids[$j]))->fetchObject();
      if (!$vds) {
        continue;
      }
      if ($vds->type == "http") {
        $content .= '   <p class="vid_title_' . $nodeid . '" ondblclick="jQuery(\'.show_vid_' . $nodeid . '\').click()" onmouseover="this.style.color=\'#' . $theme->textHoverColor . '\';this.style.background=\'rgba(' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 0, 2)) . ',' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 2, 2)) . ',' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 4, 2)) . ',0.4)\'" onmouseout="this.style.color=\'#' . $theme->textColor . '\';this.style.background=\' none\'" style="margin:0;color:#' . $theme->textColor . ';font-size:' . $theme->libDetailsTextSize . 'px;line-height:30px;cursor:pointer" onclick="jQuery(\'#HD_on_' . $nodeid . '\').val(0);jQuery(\'#track_list_' . $nodeid . '_' . $i . '\').find(\'.vid_thumb_' . $nodeid . '\')[' . $jj . '].click();playBTN_' . $nodeid . '();current_playlist_videos_' . $nodeid . '();vid_num_' . $nodeid . '=' . $jj . ';jQuery(\'#current_track_' . $nodeid . '\').val(' . $jj . ');vid_select2_' . $nodeid . '(this);playlist_select_' . $nodeid . '(' . $i . ') ">' . ($jj + 1) . ' - ' . $vds->title . '</p>';
        $jj = $jj + 1;
      }
    }
    $content .= '     </div>
                    </div>
                  </td>
                </tr>
              </table>';
  }
  $content .= '
            </td>
            <td style="vertical-align:bottom;border:none;">
              <table style="height:' . ($theme->appHeight - 46) . 'px;border:none;border-collapse:inherit;">
                <tr>
                  <td height="100%" style="border:none;">
                    <img src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/next.png" style="cursor:pointer;" id="button27_' . $nodeid . '" onclick="nextPage_' . $nodeid . '()"/>
                  </td>
                </tr>
                <tr>
                  <td style="border:none;">
                    <img src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/back.png" style="cursor:pointer;display:none" id="button29_' . $nodeid . '" onclick="openLibTable_' . $nodeid . '()"/>
                  </td>
                </tr>
                <tr>
                  <td style="border:none;">
                    <img style="cursor:pointer" id="button19_' . $nodeid . '" class="show_vid_' . $nodeid . '" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/lib.png"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr id="tracklist_down_' . $nodeid . '" style="display:none">
            <td height="22px" colspan="2" style="text-align:right;border:none;">
              <div
                onmouseover="this.style.background=\'rgba(' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 4, 2)) . ',0.4)\'"
                onmouseout="this.style.background=\'none\'" id="scroll_' . $nodeid . '"
                style="overflow:hidden;width:50%;height:100%;text-align:center;float:right;cursor:pointer;"
                onmousedown="scrollBot_' . $nodeid . '=setInterval(\'scrollBottom_' . $nodeid . '()\', 30)" onmouseup="clearInterval(scrollBot_' . $nodeid . ')">
                <img src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/bot.png" style="cursor:pointer;" id="button26_' . $nodeid . '"/>
              </div>
            </td>
          </tr>
        </table>
      </div>';
  $content .= '
      <div id="share_buttons_' . $nodeid . '" style="text-align:center;height:128px;width:30px;background-color:rgba(0,0,0,0.5);position:relative;z-index:200;top:' . (($theme->ctrlsPos == 1) ? '-' . ($theme->appHeight - 20) : '-152') . 'px;display:none;">
        <img
          onclick="flashShare_' . $nodeid . '(\'fb\',document.getElementById(\'current_playlist_table_' . $nodeid . '\').value,document.getElementById(\'current_track_' . $nodeid . '\').value)"
          style="cursor:pointer" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/facebook.png"/><br />
        <img
          onclick="flashShare_' . $nodeid . '(\'tw\',document.getElementById(\'current_playlist_table_' . $nodeid . '\').value,document.getElementById(\'current_track_' . $nodeid . '\').value)"
          style="cursor:pointer" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/twitter.png"/><br />
        <img
          onclick="flashShare_' . $nodeid . '(\'g\',document.getElementById(\'current_playlist_table_' . $nodeid . '\').value,document.getElementById(\'current_track_' . $nodeid . '\').value)"
          style="cursor:pointer" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/googleplus.png"/><br />
        <img
          onclick="jQuery(\'#embed_Url_div_' . $nodeid . '\').css(\'display\',\'\');embed_url_' . $nodeid . '(document.getElementById(\'current_playlist_table_' . $nodeid . '\').value,document.getElementById(\'current_track_' . $nodeid . '\').value)"
          style="cursor:pointer" src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/html5/embed.png"/>
      </div>
    </div>
    <div id="embed_Url_div_' . $nodeid . '" style="display:none;text-align:center;background-color:rgba(0,0,0,0.5); height:200px;width:300px;position:relative;left:' . (($theme->appWidth / 2) - 150) . 'px;top:-' . ($theme->appHeight / 2 + 75) . 'px">
      <textarea onclick="jQuery(\'#embed_Url_' . $nodeid . '\').focus(); jQuery(\'#embed_Url_' . $nodeid . '\').select();" id="embed_Url_' . $nodeid . '" readonly="readonly" style="font-size:11px;width:285px;overflow-y:scroll;resize:none;height:100px;position:relative;top:5px;"></textarea>
      <span style="position:relative;top:10px;">
        <button onclick="jQuery(\'#embed_Url_div_' . $nodeid . '\').css(\'display\',\'none\')" style="border:0px">' . t('Close') . '</button>
        <p style="color:white">' . t('Press Ctrl+C to copy the embed code to clipboard') . '</p>
      </span>
    </div>
    <input type="hidden" id="color_' . $nodeid . '" value="#' . $theme->ctrlsMainColor . '"/>
    <input type="hidden" id="support_' . $nodeid . '" value="1"/>
    <input type="hidden" id="event_type_' . $nodeid . '" value="mouseenter"/>
    <input type="hidden" id="current_track_' . $nodeid . '" value="0"/>
    <input type="hidden" id="shuffle_' . $nodeid . '" value="' . $theme->defaultShuffle . '"/>
    <input type="hidden" id="scroll_height_' . $nodeid . '" value="0"/>
    <input type="hidden" id="scroll_height2_' . $nodeid . '" value="0"/>
    <input style="display:none" type="text" value="' . $l . '" id="lib_table_count_' . $nodeid . '"/>
    <input type="hidden" value="" id="current_lib_table_' . $nodeid . '"/>
    <input type="hidden" value="0" id="current_playlist_table_' . $nodeid . '"/>
    <input type="hidden" value="' . $theme->defaultRepeat . '" id="repeat_' . $nodeid . '"/>
    <input type="hidden" value="0" id="HD_on_' . $nodeid . '"/>
    <input type="hidden" value="" id="volumeBar_width_' . $nodeid . '"/>
    <script>
      var video_' . $nodeid . ' = document.getElementById("videoID_' . $nodeid . '");
      var video_' . $nodeid . ' = jQuery("#videoID_' . $nodeid . '").get(0);
      var video_' . $nodeid . ' = jQuery("#videoID_' . $nodeid . '")[0];
      var video_' . $nodeid . ' = jQuery("#videoID_' . $nodeid . '");
      var paly_' . $nodeid . ' = jQuery(".btnPlay_' . $nodeid . '");
      var pause_' . $nodeid . ' = jQuery(".btnPause_' . $nodeid . '");
      function embed_url_' . $nodeid . '(a, b) {
        jQuery("#embed_Url_' . $nodeid . '").html(\'<iframe allowFullScreen allowTransparency="true" frameborder="0" width="' . ($theme->appWidth + 20) . '" height="' . ($theme->appHeight + 20) . '" src="' . url('spider_video_player/html5', array('query' => array('theme' => $theme_id, 'playlist' => $playlist), 'absolute' => TRUE)) . '&defaultAlbumId=\' + a + \'&defaultTrackId=\' + b + \'" type="text/html" ></iframe>\')
        jQuery("#embed_Url_' . $nodeid . '").focus();
        jQuery("#embed_Url_' . $nodeid . '").select();
      }
      jQuery(".share_' . $nodeid . ',#share_buttons_' . $nodeid . '").on("mouseenter", function () {
        left = jQuery(".share_' . $nodeid . '").position().left
        if (parseInt(jQuery("#kukla_' . $nodeid . '").css("width")) == 0) {
          jQuery("#share_buttons_' . $nodeid . '").css("left", left);
        }
        else {
          jQuery("#share_buttons_' . $nodeid . '").css("left", left + ' . (($theme->playlistPos == 1) ? $theme->playlistWidth : 0) . ');
        }
        jQuery("#share_buttons_' . $nodeid . '").css("display", "");
      })
      jQuery(".share_' . $nodeid . ',#share_buttons_' . $nodeid . '").on("mouseleave", function () {
        jQuery("#share_buttons_' . $nodeid . '").css("display", "none");
      })
      if (' . $theme->autoPlay . ' == 1) {
        setTimeout(function () {
          jQuery("#thumb_' . $nodeid . '_0").click()
        }, 500);
      }
      if ("' . $theme->defaultShuffle . '" == "shuffleOff") {
        if (jQuery(".shuffle_' . $nodeid . '")[0]) {
          jQuery(".shuffle_' . $nodeid . '")[0].style.display = "none";
          jQuery(".shuffle_' . $nodeid . '")[1].style.display = "";
        }
      }
      else {
        if (jQuery(".shuffle_' . $nodeid . '")[0]) {
          jQuery(".shuffle_' . $nodeid . '")[1].style.display = "none";
          jQuery(".shuffle_' . $nodeid . '")[0].style.display = "";
        }
      }
      jQuery(".fullScreen_' . $nodeid . '").on("click", function () {
        if (video_' . $nodeid . '[0].mozRequestFullScreen) {
          video_' . $nodeid . '[0].mozRequestFullScreen();
        }
        if (video_' . $nodeid . '[0].webkitEnterFullscreen) {
          video_' . $nodeid . '[0].webkitEnterFullscreen();
        }
      })
      jQuery(".stop").on("click", function () {
        video_' . $nodeid . '[0].currentTime = 0;
        video_' . $nodeid . '[0].pause();
        paly_' . $nodeid . '.css("display", "block");
        pause_' . $nodeid . '.css("display", "none");
      })
      if ("' . $theme->defaultRepeat . '" == "repeatOff") {
        if (jQuery(".repeat_' . $nodeid . '")[0]) {
          jQuery(".repeat_' . $nodeid . '")[0].style.display = "none";
          jQuery(".repeat_' . $nodeid . '")[1].style.display = "";
          jQuery(".repeat_' . $nodeid . '")[2].style.display = "none";
        }
      }
      if ("' . $theme->defaultRepeat . '" == "repeatOne") {
        if (jQuery(".repeat_' . $nodeid . '")[0]) {
          jQuery(".repeat_' . $nodeid . '")[0].style.display = "none";
          jQuery(".repeat_' . $nodeid . '")[1].style.display = "none";
          jQuery(".repeat_' . $nodeid . '")[2].style.display = "";
        }
      }
      if ("' . $theme->defaultRepeat . '" == "repeatAll") {
        if (jQuery(".repeat_' . $nodeid . '")[0]) {
          jQuery(".repeat_' . $nodeid . '")[0].style.display = "";
          jQuery(".repeat_' . $nodeid . '")[1].style.display = "none";
          jQuery(".repeat_' . $nodeid . '")[2].style.display = "none";
        }
      }
      jQuery(".repeat_' . $nodeid . '").on("click", function () {
        repeat_' . $nodeid . ' = jQuery("#repeat_' . $nodeid . '").val();
        switch (repeat_' . $nodeid . ') {
          case "repeatOff":
            jQuery("#repeat_' . $nodeid . '").val("repeatOne");
            jQuery(".repeat_' . $nodeid . '")[0].style.display = "none";
            jQuery(".repeat_' . $nodeid . '")[1].style.display = "none";
            jQuery(".repeat_' . $nodeid . '")[2].style.display = "";
            break;
          case "repeatOne":
            jQuery("#repeat_' . $nodeid . '").val("repeatAll");
            jQuery(".repeat_' . $nodeid . '")[0].style.display = "";
            jQuery(".repeat_' . $nodeid . '")[1].style.display = "none";
            jQuery(".repeat_' . $nodeid . '")[2].style.display = "none";
            break;
          case "repeatAll":
            jQuery("#repeat_' . $nodeid . '").val("repeatOff");
            jQuery(".repeat_' . $nodeid . '")[0].style.display = "none";
            jQuery(".repeat_' . $nodeid . '")[1].style.display = "";
            jQuery(".repeat_' . $nodeid . '")[2].style.display = "none";
            break;
        }
      })
      jQuery("#voulume_img_' . $nodeid . '").on("click", function () {
        if (jQuery(".volume_' . $nodeid . '")[0].style.width != "0%") {
          jQuery(".volume_png_' . $nodeid . '")[0].style.display = "none";
          jQuery(".volume_mute_png_' . $nodeid . '")[0].style.display = "";
          video_' . $nodeid . '[0].volume = 0;
          jQuery("#volumeBar_width_' . $nodeid . '").val(jQuery(".volume_' . $nodeid . '")[0].style.width)
          jQuery(".volume_' . $nodeid . '").css("width", "0%")
        }
        else {
          jQuery(".volume_png_' . $nodeid . '")[0].style.display = "";
          jQuery(".volume_mute_png_' . $nodeid . '")[0].style.display = "none";
          video_' . $nodeid . '[0].volume = parseInt(jQuery("#volumeBar_width_' . $nodeid . '").val()) / 100;
          jQuery(".volume_' . $nodeid . '").css("width", jQuery("#volumeBar_width_' . $nodeid . '").val())
        }
      })
      jQuery(".hd_' . $nodeid . '").on("click", function () {
        current_time = video_' . $nodeid . '[0].currentTime;
        HD_on = jQuery("#HD_on_' . $nodeid . '").val();
        current_playlist_table_' . $nodeid . ' = jQuery("#current_playlist_table_' . $nodeid . '").val();
        current_track = jQuery("#current_track_' . $nodeid . '").val();
        if (jQuery("#track_list_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').find("#urlHD_' . $nodeid . '_" + current_track).val() && HD_on == 0) {
          document.getElementById("videoID_' . $nodeid . '").src = jQuery("#track_list_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').find("#urlHD_' . $nodeid . '_" + current_track).val();
          play_' . $nodeid . '();
          setTimeout("video_' . $nodeid . '[0].currentTime=current_time", 500)
          jQuery("#HD_on_' . $nodeid . '").val(1);
        }
        if (jQuery("#track_list_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').find("#urlHD_' . $nodeid . '_" + current_track).val() && HD_on == 1) {
          jQuery("#track_list_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').find("#thumb_' . $nodeid . '_" + current_track).click();
          setTimeout("video_' . $nodeid . '[0].currentTime=current_time", 500)
          jQuery("#HD_on_' . $nodeid . '").val(0);
        }
      })
      function support_' . $nodeid . '(i, j) {
        if (jQuery("#track_list_' . $nodeid . '_" + i).find("#vid_type_' . $nodeid . '_" + j).val() != "http") {
          jQuery("#not_supported_' . $nodeid . '").css("display", "");
          jQuery("#support_' . $nodeid . '").val(0);
        }
        else {
          jQuery("#not_supported_' . $nodeid . '").css("display", "none");
          jQuery("#support_' . $nodeid . '").val(1);
        }
      }
      jQuery(".play_' . $nodeid . '").on("click", function () {
        video_' . $nodeid . '[0].play();
      })
      jQuery(".pause_' . $nodeid . '").on("click", function () {
        video_' . $nodeid . '[0].pause();
      })
      function vid_select_' . $nodeid . '(x) {
        jQuery("div.vid_thumb_' . $nodeid . '").each(function () {
          if (jQuery(this).find("img")) {
            jQuery(this).find("img").hide(20);
            if (jQuery(this).find("img")[0])
              jQuery(this).find("img")[0].style.display = "none";
          }
          jQuery(this).css("background", "none");
        })
        jQuery("div.vid_thumb_' . $nodeid . '").each(function () {
          jQuery(this).mouseenter(function () {
            if (jQuery(this).find("img"))
              jQuery(this).find("img").slideDown(100);
            jQuery(this).css("background", "rgba(' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 4, 2)) . ', ' . $theme->framesBgAlpha / 100 . ')")
            jQuery(this).css("color", "#' . $theme->textHoverColor . '")
          })
          jQuery(this).mouseleave(function () {
            if (jQuery(this).find("img")) {
              jQuery(this).find("img").slideUp(300);
            }
            jQuery(this).css("background", "none");
            jQuery(this).css("color", "#' . $theme->textColor . '")
          });
          jQuery(this).css("color", "#' . $theme->textColor . '")
        })
        jQuery(x).unbind("mouseleave mouseenter");
        if (jQuery(x).find("img"))
          jQuery(x).find("img").show(10);
        jQuery(x).css("background", "rgba(' . HEXDEC(SUBSTR($theme->itemBgSelectedColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgSelectedColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgSelectedColor, 4, 2)) . ', ' . $theme->framesBgAlpha / 100 . ')")
        jQuery(x).css("color", "#' . $theme->textSelectedColor . '")
      }
      function vid_select2_' . $nodeid . '(x) {
        jQuery("p.vid_title_' . $nodeid . '").each(function () {
          this.onmouseover = function () {
            this.style.color = "#" + "' . $theme->textHoverColor . '";
            this.style.background = "rgba(' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 4, 2)) . ',0.4)"
          }
          this.onmouseout = function () {
            this.style.color = "#' . $theme->textColor . '";
            this.style.background = " none"
          }
          jQuery(this).css("background", "none");
          jQuery(this).css("color", "#' . $theme->textColor . '");
        })
        jQuery(x).css("background", "rgba(' . HEXDEC(SUBSTR($theme->itemBgSelectedColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgSelectedColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgSelectedColor, 4, 2)) . ', ' . $theme->framesBgAlpha / 100 . ')")
        jQuery(x).css("color", "#' . $theme->textSelectedColor . '")
        x.onmouseover = null;
        x.onmouseout = null;
      }
      function playlist_select_' . $nodeid . '(x) {
        jQuery("td.playlist_td_' . $nodeid . '").each(function () {
          jQuery(this).css("background", "none");
          jQuery(this).css("color", "#' . $theme->textColor . '");
          this.onmouseover = function () {
            this.style.color = "#' . $theme->textHoverColor . '";
            this.style.background = "rgba(' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 4, 2)) . ',0.4)"
          }
          this.onmouseout = function () {
            this.style.color = "#' . $theme->textColor . '";
            this.style.background = " none"
          }
        })
        jQuery("#playlist_' . $nodeid . '_" + x).css("background", "rgba(' . HEXDEC(SUBSTR($theme->itemBgSelectedColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgSelectedColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgSelectedColor, 4, 2)) . ', ' . $theme->framesBgAlpha / 100 . ')")
        jQuery("#playlist_' . $nodeid . '_" + x).css("color", "#' . $theme->textSelectedColor . '")
        jQuery("#playlist_' . $nodeid . '_" + x)[0].onmouseover = null
        jQuery("#playlist_' . $nodeid . '_" + x)[0].onmouseout = null
      }
      jQuery(".shuffle_' . $nodeid . '").on("click", function () {
        if (jQuery("#shuffle_' . $nodeid . '").val() == 0) {
          jQuery("#shuffle_' . $nodeid . '").val(1);
          jQuery(".shuffle_' . $nodeid . '")[1].style.display = "none";
          jQuery(".shuffle_' . $nodeid . '")[0].style.display = "";
        }
        else {
          jQuery("#shuffle_' . $nodeid . '").val(0);
          jQuery(".shuffle_' . $nodeid . '")[0].style.display = "none";
          jQuery(".shuffle_' . $nodeid . '")[1].style.display = "";
        }
      });
      jQuery("div.vid_thumb_' . $nodeid . '").each(function () {
        jQuery(this).mouseenter(function () {
          if (jQuery(this).find("img")) {
            jQuery(this).find("img").slideToggle(100);
          }
          jQuery(this).css("background", "rgba(' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 0, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 2, 2)) . ', ' . HEXDEC(SUBSTR($theme->itemBgHoverColor, 4, 2)) . ', ' . $theme->framesBgAlpha / 100 . ')")
          jQuery(this).css("color", "#' . $theme->textHoverColor . '")
        })
        jQuery(this).mouseleave(function () {
          if (jQuery(this).find("img")) {
            jQuery(this).find("img").slideToggle(300);
          }
          jQuery(this).css("background", "none");
          jQuery(this).css("color", "#' . $theme->textColor . '")
        });
      })
      function timeUpdate_' . $nodeid . '() {
        if (parseInt(document.getElementById("videoID_' . $nodeid . '").currentTime / 60) < 10 && parseInt(document.getElementById("videoID_' . $nodeid . '").currentTime % 60 < 10)) {
          document.getElementById("time_' . $nodeid . '").innerHTML = "0" + parseInt(document.getElementById("videoID_' . $nodeid . '").currentTime / 60) + ":0" + parseInt(document.getElementById("videoID_' . $nodeid . '").currentTime % 60);
        }
        if (parseInt(document.getElementById("videoID_' . $nodeid . '").currentTime / 60) < 10) {
          document.getElementById("time_' . $nodeid . '").innerHTML = "0" + parseInt(document.getElementById("videoID_' . $nodeid . '").currentTime / 60) + ":" + parseInt(document.getElementById("videoID_' . $nodeid . '").currentTime % 60);
        }
        if (parseInt(document.getElementById("videoID_' . $nodeid . '").currentTime % 60) < 10) {
          document.getElementById("time_' . $nodeid . '").innerHTML = "0" + parseInt(document.getElementById("videoID_' . $nodeid . '").currentTime / 60) + ":0" + parseInt(document.getElementById("videoID_' . $nodeid . '").currentTime % 60);
        }
      }
      function durationChange_' . $nodeid . '() {
        if (parseInt(document.getElementById("videoID_' . $nodeid . '").duration / 60) < 10 && parseInt(document.getElementById("videoID_' . $nodeid . '").duration % 60 < 10)) {
          document.getElementById("duration_' . $nodeid . '").innerHTML = "0" + parseInt(document.getElementById("videoID_' . $nodeid . '").duration / 60) + ":0" + parseInt(document.getElementById("videoID_' . $nodeid . '").duration % 60);
        }
        if (parseInt(document.getElementById("videoID_' . $nodeid . '").duration / 60) < 10) {
          document.getElementById("duration_' . $nodeid . '").innerHTML = "0" + parseInt(document.getElementById("videoID_' . $nodeid . '").duration / 60) + ":" + parseInt(document.getElementById("videoID_' . $nodeid . '").duration % 60);
        }
        if (parseInt(document.getElementById("videoID_' . $nodeid . '").duration % 60) < 10) {
          document.getElementById("duration_' . $nodeid . '").innerHTML = parseInt(document.getElementById("videoID_' . $nodeid . '").duration / 60) + ":0" + parseInt(document.getElementById("videoID_' . $nodeid . '").duration % 60);
        }
      }
      function scrollBottom_' . $nodeid . '() {
        current_playlist_table_' . $nodeid . ' = document.getElementById("current_playlist_table_' . $nodeid . '").value;
        if (document.getElementById("scroll_div_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').offsetHeight + parseInt(document.getElementById("scroll_div_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').style.top) + 55 <= document.getElementById("global_body_' . $nodeid . '").offsetHeight) {
          return false;
        }
        document.getElementById("scroll_height_' . $nodeid . '").value = parseInt(document.getElementById("scroll_height_' . $nodeid . '").value) + 5
        document.getElementById("scroll_div_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').style.top = "-" + document.getElementById("scroll_height_' . $nodeid . '").value + "px";
      };
      function scrollTop_' . $nodeid . '() {
        current_playlist_table_' . $nodeid . ' = document.getElementById("current_playlist_table_' . $nodeid . '").value;
        if (document.getElementById("scroll_height_' . $nodeid . '").value <= 0) {
          return false;
        }
        document.getElementById("scroll_height_' . $nodeid . '").value = parseInt(document.getElementById("scroll_height_' . $nodeid . '").value) - 5
        document.getElementById("scroll_div_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').style.top = "-" + document.getElementById("scroll_height_' . $nodeid . '").value + "px";
      };
      function scrollBottom2_' . $nodeid . '() {
        current_playlist_table_' . $nodeid . ' = document.getElementById("current_playlist_table_' . $nodeid . '").value;
        if (!current_playlist_table_' . $nodeid . ') {
          current_playlist_table_' . $nodeid . ' = 0;
        }
        if (document.getElementById("scroll_div2_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').offsetHeight + parseInt(document.getElementById("scroll_div2_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').style.top) + 150 <= document.getElementById("global_body_' . $nodeid . '").offsetHeight) {
          return false;
        }
        document.getElementById("scroll_height2_' . $nodeid . '").value = parseInt(document.getElementById("scroll_height2_' . $nodeid . '").value) + 5
        document.getElementById("scroll_div2_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').style.top = "-" + document.getElementById("scroll_height2_' . $nodeid . '").value + "px";
      };
      function scrollTop2_' . $nodeid . '() {
        current_playlist_table_' . $nodeid . ' = document.getElementById("current_playlist_table_' . $nodeid . '").value;
        if (document.getElementById("scroll_height2_' . $nodeid . '").value <= 0) {
          return false;
        }
        document.getElementById("scroll_height2_' . $nodeid . '").value = parseInt(document.getElementById("scroll_height2_' . $nodeid . '").value) - 5
        document.getElementById("scroll_div2_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').style.top = "-" + document.getElementById("scroll_height2_' . $nodeid . '").value + "px";
      };
      function openPlaylist_' . $nodeid . '(i, j) {
        document.getElementById("scroll_height_' . $nodeid . '").value = 0;
        lib_table_count_' . $nodeid . ' = document.getElementById("lib_table_count_' . $nodeid . '").value;
        for (lib_table_' . $nodeid . ' = 0; lib_table_' . $nodeid . ' < lib_table_count_' . $nodeid . '; lib_table_' . $nodeid . '++) {
          document.getElementById("lib_table_' . $nodeid . '_" + lib_table_' . $nodeid . ').style.display = "none";
        }
        jQuery("#playlist_table_' . $nodeid . '_" + i).fadeIn(700);
        document.getElementById("current_lib_table_' . $nodeid . '").value = j;
        document.getElementById("current_playlist_table_' . $nodeid . '").value = i;
        document.getElementById("tracklist_down_' . $nodeid . '").style.display = "";
        document.getElementById("tracklist_up_' . $nodeid . '").style.display = "";
        document.getElementById("button29_' . $nodeid . '").style.display = "block";
        document.getElementById("button27_' . $nodeid . '").onclick = function () {
          nextPlaylist_' . $nodeid . '()
        };
        document.getElementById("button28_' . $nodeid . '").onclick = function () {
          prevPlaylist_' . $nodeid . '()
        };
      }
      function nextPlaylist_' . $nodeid . '() {
        document.getElementById("scroll_height_' . $nodeid . '").value = 0;
        lib_table_count_' . $nodeid . ' = document.getElementById("lib_table_count_' . $nodeid . '").value;
        for (lib_table_' . $nodeid . ' = 0; lib_table_' . $nodeid . ' < lib_table_count_' . $nodeid . '; lib_table_' . $nodeid . '++) {
          document.getElementById("lib_table_' . $nodeid . '_" + lib_table_' . $nodeid . ').style.display = "none";
        }
        current_lib_table_' . $nodeid . ' = document.getElementById("current_lib_table_' . $nodeid . '").value;
        next_playlist_table = parseInt(document.getElementById("current_playlist_table_' . $nodeid . '").value) + 1;
        current_playlist_table_' . $nodeid . ' = parseInt(document.getElementById("current_playlist_table_' . $nodeid . '").value);
        if (next_playlist_table > ' . (count($playlist_array) - 2) . ') {
          return false;
        }
        jQuery("#playlist_table_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').css("display", "none");
        jQuery("#playlist_table_' . $nodeid . '_" + next_playlist_table).fadeIn(700);
        document.getElementById("current_playlist_table_' . $nodeid . '").value = next_playlist_table;
        document.getElementById("tracklist_down_' . $nodeid . '").style.display = "";
        document.getElementById("tracklist_up_' . $nodeid . '").style.display = "";
        document.getElementById("button29_' . $nodeid . '").style.display = "block";
      }
      function prevPlaylist_' . $nodeid . '() {
        document.getElementById("scroll_height_' . $nodeid . '").value = 0;
        lib_table_count_' . $nodeid . ' = document.getElementById("lib_table_count_' . $nodeid . '").value;
        for (lib_table_' . $nodeid . ' = 0; lib_table_' . $nodeid . ' < lib_table_count_' . $nodeid . '; lib_table_' . $nodeid . '++) {
          document.getElementById("lib_table_' . $nodeid . '_" + lib_table_' . $nodeid . ').style.display = "none";
        }
        current_lib_table_' . $nodeid . ' = document.getElementById("current_lib_table_' . $nodeid . '").value;
        prev_playlist_table = parseInt(document.getElementById("current_playlist_table_' . $nodeid . '").value) - 1;
        current_playlist_table_' . $nodeid . ' = parseInt(document.getElementById("current_playlist_table_' . $nodeid . '").value);
        if (prev_playlist_table < 0) {
          return false;
        }
        jQuery("#playlist_table_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').css("display", "none");
        jQuery("#playlist_table_' . $nodeid . '_" + prev_playlist_table).fadeIn(700);
        document.getElementById("current_playlist_table_' . $nodeid . '").value = prev_playlist_table;
        document.getElementById("tracklist_down_' . $nodeid . '").style.display = "";
        document.getElementById("tracklist_up_' . $nodeid . '").style.display = "";
        document.getElementById("button29_' . $nodeid . '").style.display = "block";
      }
      function openLibTable_' . $nodeid . '() {
        current_lib_table_' . $nodeid . ' = document.getElementById("current_lib_table_' . $nodeid . '").value;
        document.getElementById("scroll_height_' . $nodeid . '").value = 0;
        current_playlist_table_' . $nodeid . ' = document.getElementById("current_playlist_table_' . $nodeid . '").value;
        jQuery("#lib_table_' . $nodeid . '_" + current_lib_table_' . $nodeid . ').fadeIn(700);
        document.getElementById("playlist_table_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').style.display = "none";
        document.getElementById("tracklist_down_' . $nodeid . '").style.display = "none";
        document.getElementById("tracklist_up_' . $nodeid . '").style.display = "none";
        document.getElementById("button29_' . $nodeid . '").style.display = "none";
        document.getElementById("button27_' . $nodeid . '").onclick = function () {
          nextPage_' . $nodeid . '()
        };
        document.getElementById("button28_' . $nodeid . '").onclick = function () {
          prevPage_' . $nodeid . '()
        };
      }
      var next_page_' . $nodeid . ' = 0;
      function nextPage_' . $nodeid . '() {
        if (next_page_' . $nodeid . ' == document.getElementById("lib_table_count_' . $nodeid . '").value - 1) {
          return false;
        }
        next_page_' . $nodeid . ' = next_page_' . $nodeid . ' + 1;
        for (g = 0; g < document.getElementById("lib_table_count_' . $nodeid . '").value; g++) {
          document.getElementById("lib_table_' . $nodeid . '_" + g).style.display = "none";
          if (g == next_page_' . $nodeid . ') {
            jQuery("#lib_table_' . $nodeid . '_" + g).fadeIn(900);
          }
        }
      }
      function prevPage_' . $nodeid . '() {
        if (next_page_' . $nodeid . ' == 0) {
          return false;
        }
        next_page_' . $nodeid . ' = next_page_' . $nodeid . ' - 1;
        for (g = 0; g < document.getElementById("lib_table_count_' . $nodeid . '").value; g++) {
          document.getElementById("lib_table_' . $nodeid . '_" + g).style.display = "none";
          if (g == next_page_' . $nodeid . ') {
            jQuery("#lib_table_' . $nodeid . '_" + g).fadeIn(900);
          }
        }
      }
      function playBTN_' . $nodeid . '() {
        current_playlist_table_' . $nodeid . ' = document.getElementById("current_playlist_table_' . $nodeid . '").value;
        track_list_' . $nodeid . ' = document.getElementById("track_list_' . $nodeid . '").value;
        document.getElementById("track_list_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').style.display = "block";
        if (current_playlist_table_' . $nodeid . ' != track_list_' . $nodeid . ') {
          document.getElementById("track_list_' . $nodeid . '_" + track_list_' . $nodeid . ').style.display = "none";
        }
        document.getElementById("track_list_' . $nodeid . '").value = current_playlist_table_' . $nodeid . ';
        video_' . $nodeid . '[0].play();
        paly_' . $nodeid . '.css("display", "none");
        pause_' . $nodeid . '.css("display", "block");
      }
      function play_' . $nodeid . '() {
        video_' . $nodeid . '[0].play();
        paly_' . $nodeid . '.css("display", "none");
        pause_' . $nodeid . '.css("display", "block");
      }
      // Play/Pause control clicked.
      jQuery(".btnPlay_' . $nodeid . ' ' . (($theme->clickOnVid == 1) ? ',#videoID_' . $nodeid : '') . ', .btnPause_' . $nodeid . '").on("click", function () {
        if (video_' . $nodeid . '[0].paused) {
          video_' . $nodeid . '[0].play();
          paly_' . $nodeid . '.css("display", "none");
          pause_' . $nodeid . '.css("display", "block");
        }
        else {
          video_' . $nodeid . '[0].pause();
          paly_' . $nodeid . '.css("display", "block");
          pause_' . $nodeid . '.css("display", "none");
        }
        return false;
      });
      function check_volume_' . $nodeid . '() {
        percentage_' . $nodeid . ' = video_' . $nodeid . '[0].volume * 100;
        jQuery(".volume_' . $nodeid . '").css("width", percentage_' . $nodeid . ' + "%");
        document.getElementById("kukla_' . $nodeid . '").style.width = "0px";
        document.getElementById("kukla_' . $nodeid . '").style.display = "none";
      }
      window.onload = check_volume_' . $nodeid . '();
      // Get video time duration.
      video_' . $nodeid . '.on("loadedmetadata", function () {
        jQuery(".duration_' . $nodeid . '").text(video_' . $nodeid . '[0].duration);
      });
      // Update video current play time.
      video_' . $nodeid . '.on("timeupdate", function () {
        var progress_' . $nodeid . ' = jQuery(".progressBar_' . $nodeid . '");
        var currentPos_' . $nodeid . ' = video_' . $nodeid . '[0].currentTime;
        var maxduration_' . $nodeid . ' = video_' . $nodeid . '[0].duration;
        var percentage_' . $nodeid . ' = 100 * currentPos_' . $nodeid . ' / maxduration_' . $nodeid . ';
        var position_' . $nodeid . ' = (' . $theme->appWidth . ' * percentage_' . $nodeid . ' / 100) - progress_' . $nodeid . '.offset().left;
        jQuery(".timeBar_' . $nodeid . '").css("width", percentage_' . $nodeid . ' + "%");
      });
      video_' . $nodeid . '.on("ended", function () {
        if (jQuery("#repeat_' . $nodeid . '").val() == "repeatOne") {
          video_' . $nodeid . '[0].currentTime = 0;
          video_' . $nodeid . '[0].play();
          paly_' . $nodeid . '.css("display", "none");
          pause_' . $nodeid . '.css("display", "block");
        }
        if (jQuery("#repeat_' . $nodeid . '").val() == "repeatAll") {
          jQuery(".playNext_' . $nodeid . '").click();
        }
        if (jQuery("#repeat_' . $nodeid . '").val() == "repeatOff") {
          if (vid_num_' . $nodeid . ' == video_urls_' . $nodeid . '.length - 1) {
            video_' . $nodeid . '[0].currentTime = 0;
            video_' . $nodeid . '[0].pause();
            paly_' . $nodeid . '.css("display", "block");
            pause_' . $nodeid . '.css("display", "none");
          }
        }
        if (' . $theme->autoNext . ' == 1) {
        if (jQuery("#repeat_' . $nodeid . '").val() == "repeatOff")
          if (vid_num_' . $nodeid . ' == video_urls_' . $nodeid . '.length - 1) {
            video_' . $nodeid . '[0].currentTime = 0;
            video_' . $nodeid . '[0].pause();
            paly_' . $nodeid . '.css("display", "block");
            pause_' . $nodeid . '.css("display", "none");
          }
          else {
            jQuery(".playNext_' . $nodeid . '").click();
          }
        }
      })
      var timeDrag_' . $nodeid . ' = false;
      jQuery(".progressBar_' . $nodeid . '").mousedown(function (e) {
        timeDrag_' . $nodeid . ' = true;
        updatebar_' . $nodeid . '(e.pageX);
      });
      jQuery(".progressBar_' . $nodeid . '").select(function () {
      })
      jQuery(document).mouseup(function (e) {
        if (timeDrag_' . $nodeid . ') {
          timeDrag_' . $nodeid . ' = false;
          updatebar_' . $nodeid . '(e.pageX);
        }
      });
      jQuery(document).mousemove(function (e) {
        if (timeDrag_' . $nodeid . ') {
          updatebar_' . $nodeid . '(e.pageX);
        }
      });
      // Update Progress Bar control.
      var updatebar_' . $nodeid . ' = function (x) {
        var progress_' . $nodeid . ' = jQuery(".progressBar_' . $nodeid . '");
        var maxduration_' . $nodeid . ' = video_' . $nodeid . '[0].duration;
        var position_' . $nodeid . ' = x - progress_' . $nodeid . '.offset().left;
        var percentage_' . $nodeid . ' = 100 * position_' . $nodeid . ' / progress_' . $nodeid . '.width();
        // Check within range.
        if (percentage_' . $nodeid . ' > 100) {
          percentage_' . $nodeid . ' = 100;
        }
        if (percentage_' . $nodeid . ' < 0) {
          percentage_' . $nodeid . ' = 0;
        }
        // Update progress bar and video currenttime.
        jQuery(".timeBar_' . $nodeid . '").css("width", percentage_' . $nodeid . ' + "%");
        jQuery(".spanA").css("left", position_' . $nodeid . ' + "px");
        video_' . $nodeid . '[0].currentTime = maxduration_' . $nodeid . ' * percentage_' . $nodeid . ' / 100;
      };
      // Get video buffered data.
      function startBuffer_' . $nodeid . '() {
        setTimeout(function () {
          var maxduration_' . $nodeid . ' = video_' . $nodeid . '[0].duration;
          var currentBuffer_' . $nodeid . ' = video_' . $nodeid . '[0].buffered.end(0);
          var percentage_' . $nodeid . ' = 100 * currentBuffer_' . $nodeid . ' / maxduration_' . $nodeid . ';
          jQuery(".bufferBar_' . $nodeid . '").css("width", percentage_' . $nodeid . ' + "%");
          if (currentBuffer_' . $nodeid . ' < maxduration_' . $nodeid . ') {
            setTimeout(startBuffer_' . $nodeid . ', 500);
          }
        }, 800)
      };
      checkVideoLoad_' . $nodeid . ' = setInterval(function () {
        if (video_' . $nodeid . '[0].duration) {
          setTimeout(startBuffer_' . $nodeid . ', 500);
          clearInterval(checkVideoLoad_' . $nodeid . ')
        }
      }, 1000)
      // Mute/Unmute control clicked.
      var volume_' . $nodeid . ' = jQuery(".volumeBar_' . $nodeid . '");
      jQuery(".muted_' . $nodeid . '").click(function () {
        video_' . $nodeid . '[0].muted = !video_' . $nodeid . '[0].muted;
        return false;
      });
      // Volume control clicked.
      jQuery(".volumeBar_' . $nodeid . '").on("mousedown", function (e) {
        var position_' . $nodeid . ' = e.pageX - volume_' . $nodeid . '.offset().left;
        var percentage_' . $nodeid . ' = 100 * position_' . $nodeid . ' / volume_' . $nodeid . '.width();
        jQuery(".volume_' . $nodeid . '").css("width", percentage_' . $nodeid . ' + "%");
        video_' . $nodeid . '[0].volume = percentage_' . $nodeid . ' / 100;
      });
      var volumeDrag_' . $nodeid . ' = false;
      jQuery(".volumeBar_' . $nodeid . '").mousedown(function (e) {
        volumeDrag_' . $nodeid . ' = true;
        updateVolumeBar_' . $nodeid . '(e.pageX);
      });
      jQuery(document).mouseup(function (e) {
        if (volumeDrag_' . $nodeid . ') {
          volumeDrag_' . $nodeid . ' = false;
          updateVolumeBar_' . $nodeid . '(e.pageX);
        }
      });
      jQuery(document).mousemove(function (e) {
        if (volumeDrag_' . $nodeid . ') {
          updateVolumeBar_' . $nodeid . '(e.pageX);
        }
      });
      var updateVolumeBar_' . $nodeid . ' = function (x) {
        var progress_' . $nodeid . ' = jQuery(".volumeBar_' . $nodeid . '");
        var position_' . $nodeid . ' = x - progress_' . $nodeid . '.offset().left;
        var percentage_' . $nodeid . ' = 100 * position_' . $nodeid . ' / progress_' . $nodeid . '.width();
        // Check within range.
        if (percentage_' . $nodeid . ' > 100) {
          percentage_' . $nodeid . ' = 100;
        }
        if (percentage_' . $nodeid . ' < 0) {
          percentage_' . $nodeid . ' = 0;
        }
        jQuery(".volume_' . $nodeid . '").css("width", percentage_' . $nodeid . ' + "%");
        video_' . $nodeid . '[0].volume = percentage_' . $nodeid . ' / 100;
      };
      var yy = 1;
      controlHideTime_' . $nodeid . ' = "";
      jQuery("#global_body_' . $nodeid . '").each(function () {
        jQuery(this).mouseleave(function () {
          controlHideTime_' . $nodeid . ' = setInterval(function () {
            yy = yy + 1;
            if (yy < ' . $theme->autohideTime . ') {
              return false
            }
            else {
              clearInterval(controlHideTime_' . $nodeid . ');
              yy = 1;
              jQuery("#event_type_' . $nodeid . '").val("mouseleave");';
  if ($theme->playlistAutoHide == 1) {
    $content .= '
              jQuery("#kukla_' . $nodeid . '").animate({
                width:"0px",
              }, 300);
              setTimeout(function () {
                jQuery("#kukla_' . $nodeid . '").css("display", "none");
              }, 300)
              jQuery(".control_' . $nodeid . '").animate({
                width:"' . $theme->appWidth . 'px",
                ' . (($theme->playlistPos == 1) ? 'marginLeft:"0px"' : 'marginRight:"0px"') . '
              }, 300);
              jQuery("#control_btns_' . $nodeid . '").animate({
                width:"' . $theme->appWidth . '.px",
              }, 300);';
  }
  if ($theme->ctrlsSlideOut == 1) {
    $content .= '
              jQuery(".control_' . $nodeid . '").hide("slide", { direction:"' . (($theme->ctrlsPos == 1) ? 'up' : 'down') . '" }, 1000);';
  }
  $content .= '
            }
          }, 1000);
        });
        jQuery(this).mouseenter(function () {
          if (controlHideTime_' . $nodeid . ') {
            clearInterval(controlHideTime_' . $nodeid . ')
            yy = 1;
          }
          if (document.getElementById("control_' . $nodeid . '").style.display == "none") {
            jQuery(".control_' . $nodeid . '").show("slide", { direction:"' . (($theme->ctrlsPos == 1) ? 'up' : 'down') . '" }, 450);
          }
        })
      })
      var xx = 1;
      volumeHideTime_' . $nodeid . ' = "";
      jQuery("#volumeTD_' . $nodeid . '").each(function () {
        jQuery("#volumeTD_' . $nodeid . '").mouseleave(function () {
          volumeHideTime_' . $nodeid . ' = setInterval(function () {
            xx = xx + 1;
            if (xx < 2) {
              return false;
            }
            else {
              clearInterval(volumeHideTime_' . $nodeid . ');
              xx = 1;
              jQuery("#space_' . $nodeid . '").animate({
                paddingLeft:"' . (($theme->appWidth * 20) / 100) . 'px",
              }, 1000);
              jQuery("#volumebar_player_' . $nodeid . '").animate({
                width:"0px",
              }, 1000);
              percentage_' . $nodeid . ' = video_' . $nodeid . '[0].volume * 100;
              jQuery(".volume_' . $nodeid . '").css("width", percentage_' . $nodeid . ' + "%");
            }
          }, 1000)
        })
        jQuery("#volumeTD_' . $nodeid . '").mouseenter(function () {
          if (volumeHideTime_' . $nodeid . ') {
            clearInterval(volumeHideTime_' . $nodeid . ');
            xx = 1;
          }
          jQuery("#space_' . $nodeid . '").animate({
            paddingLeft:"' . ((($theme->appWidth * 20) / 100) - 100) . 'px",
          }, 500);
          jQuery("#volumebar_player_' . $nodeid . '").animate({
            width:"100px",
          }, 500);
        });
      })
      jQuery(".playlist_' . $nodeid . '").on("click", function () {
        if (document.getElementById("kukla_' . $nodeid . '").style.width == "0px") {
          jQuery("#kukla_' . $nodeid . '").css("display", "")
          jQuery("#kukla_' . $nodeid . '").animate({
            width:"' . $theme->playlistWidth . 'px",
          }, 500);
          jQuery(".control_' . $nodeid . '").animate({
            width:"' . ($theme->appWidth - $theme->playlistWidth) . 'px",
            ' . (($theme->playlistPos == 1) ? 'marginLeft' : 'marginRight') . ':"' . $theme->playlistWidth . 'px"
          }, 500);
          jQuery("#control_btns_' . $nodeid . '").animate({
            width:"' . ($theme->appWidth - $theme->playlistWidth) . 'px",
          }, 500);
        }
        else {
          jQuery("#kukla_' . $nodeid . '").animate({
            width:"0px",
          }, 1500);
          setTimeout(function () {
            jQuery("#kukla_' . $nodeid . '").css("display", "none");
          }, 1500)
          jQuery(".control_' . $nodeid . '").animate({
            width:"' . $theme->appWidth . 'px",
            ' . (($theme->playlistPos == 1) ? 'marginLeft' : 'marginRight') . ':"0px"
          }, 1500);
          jQuery("#control_btns_' . $nodeid . '").animate({
            width:"' . $theme->appWidth . 'px",
          }, 1500);
        }
      });
      current_playlist_table_' . $nodeid . ' = document.getElementById("current_playlist_table_' . $nodeid . '").value;
      video_urls_' . $nodeid . ' = jQuery("#track_list_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').find(".vid_thumb_' . $nodeid . '");
      function current_playlist_videos_' . $nodeid . '() {
        current_playlist_table_' . $nodeid . ' = document.getElementById("current_playlist_table_' . $nodeid . '").value;
        video_urls_' . $nodeid . ' = jQuery("#track_list_' . $nodeid . '_" + current_playlist_table_' . $nodeid . ').find(".vid_thumb_' . $nodeid . '");
      }
      var vid_num_' . $nodeid . ' = 0;
      jQuery(".playPrev_' . $nodeid . '").on("click", function () {
        vid_num_' . $nodeid . '--;
        if (jQuery("#shuffle_' . $nodeid . '").val() == "shuffleOn") {
          vid_num_' . $nodeid . ' = parseInt(Math.random() * (video_urls_' . $nodeid . '.length + 1 - 0) + 0);
        }
        if (vid_num_' . $nodeid . ' < 0) {
          vid_num_' . $nodeid . ' = video_urls_' . $nodeid . '.length - 1;
        }
        video_urls_' . $nodeid . '[vid_num_' . $nodeid . '].click()
      });
      jQuery(".playNext_' . $nodeid . '").on("click", function () {
        vid_num_' . $nodeid . '++;
        if (jQuery("#shuffle_' . $nodeid . '").val() == 1) {
          vid_num_' . $nodeid . ' = parseInt(Math.random() * (video_urls_' . $nodeid . '.length + 1 - 0) + 0);
        }
        jQuery(".timeBar_' . $nodeid . '").css("width", "0%");
        if (vid_num_' . $nodeid . ' == video_urls_' . $nodeid . '.length) {
          vid_num_' . $nodeid . ' = 0;
        }
        video_urls_' . $nodeid . '[vid_num_' . $nodeid . '].click()
      });
      jQuery(".lib_' . $nodeid . '").click(function () {
        jQuery("#album_div_' . $nodeid . '").css("transform","");
        jQuery("#global_body_' . $nodeid . '").css("transform","");
        jQuery("#global_body_' . $nodeid . '").transition({
          perspective: "700px",
          rotateY: "180deg",
        },1000);
        setTimeout(function(){
          jQuery("#album_div_' . $nodeid . '").css("-ms-transform","rotateY(180deg)")
          jQuery("#album_div_' . $nodeid . '").css("transform","rotateY(180deg)")
          jQuery("#album_div_' . $nodeid . '").css("-o-transform","rotateY(180deg)")
          document.getElementById("album_div_' . $nodeid . '").style.display="block"
          document.getElementById("video_div_' . $nodeid . '").style.display="none"
        },300);
        setTimeout(function(){
          jQuery("#album_div_' . $nodeid . '").css("-ms-transform","");
          jQuery("#global_body_' . $nodeid . '").css("-ms-transform","");
          jQuery("#album_div_' . $nodeid . '").css("transform","");
          jQuery("#global_body_' . $nodeid . '").css("transform","");
          jQuery("#album_div_' . $nodeid . '").css("-o-transform","");
          jQuery("#global_body_' . $nodeid . '").css("-o-transform","");
        },1100);
      })
      jQuery(".show_vid_' . $nodeid . '").click(function () {
        jQuery("#global_body_' . $nodeid . '").transition({
          perspective: "700px",
          rotateY: "180deg",
        },1000);
        setTimeout(function(){
          jQuery("#video_div_' . $nodeid . '").css("-ms-transform","rotateY(180deg)")
          jQuery("#video_div_' . $nodeid . '").css("transform","rotateY(180deg)")
          jQuery("#video_div_' . $nodeid . '").css("-o-transform","rotateY(180deg)")
          document.getElementById("album_div_' . $nodeid . '").style.display="none"
          document.getElementById("video_div_' . $nodeid . '").style.display="block"
        },300);	
        setTimeout(function(){
          jQuery("#video_div_' . $nodeid . '").css("-ms-transform","");
          jQuery("#global_body_' . $nodeid . '").css("-ms-transform","");
          jQuery("#video_div_' . $nodeid . '").css("transform","");
          jQuery("#global_body_' . $nodeid . '").css("transform",""); 
          jQuery("#video_div_' . $nodeid . '").css("-o-transform","");
          jQuery("#global_body_' . $nodeid . '").css("-o-transform","");
        },1100);
      })
      // Color.
      var canvas_' . $nodeid . ' = []
      var ctx_' . $nodeid . ' = []
      var originalPixels_' . $nodeid . ' = []
      var currentPixels_' . $nodeid . ' = []
      for (i = 1; i < 31; i++) {
        if (document.getElementById("button" + i + "_' . $nodeid . '")) {
          canvas_' . $nodeid . '[i] = document.createElement("canvas");
          ctx_' . $nodeid . '[i] = canvas_' . $nodeid . '[i].getContext("2d");
          originalPixels_' . $nodeid . '[i] = null;
          currentPixels_' . $nodeid . '[i] = null;
        }
      }
      function getPixels_' . $nodeid . '() {
        for (i = 1; i < 31; i++) {
          if (document.getElementById("button" + i + "_' . $nodeid . '")) {
            img = document.getElementById("button" + i + "_' . $nodeid . '");
            canvas_' . $nodeid . '[i].width = img.width;
            canvas_' . $nodeid . '[i].height = img.height;
            ctx_' . $nodeid . '[i].drawImage(img, 0, 0, img.naturalWidth, img.naturalHeight, 0, 0, img.width, img.height);
            originalPixels_' . $nodeid . '[i] = ctx_' . $nodeid . '[i].getImageData(0, 0, img.width, img.height);
            currentPixels_' . $nodeid . '[i] = ctx_' . $nodeid . '[i].getImageData(0, 0, img.width, img.height);
            img.onload = null;
          }
        }
      }
      function HexToRGB_' . $nodeid . '(Hex) {
        var Long = parseInt(Hex.replace(/^#/, ""), 16);
        return {
          R:(Long >>> 16) & 0xff,
          G:(Long >>> 8) & 0xff,
          B:Long & 0xff
        };
      }
      function changeColor_' . $nodeid . '() {
        for (i = 1; i < 31; i++) {
          if (document.getElementById("button" + i + "_' . $nodeid . '")) {
            if (!originalPixels_' . $nodeid . '[i]) {
              return;
            }
            var newColor = HexToRGB_' . $nodeid . '(document.getElementById("color_' . $nodeid . '").value);
            for (var I = 0, L = originalPixels_' . $nodeid . '[i].data.length; I < L; I += 4) {
              if (currentPixels_' . $nodeid . '[i].data[I + 3] > 0) {
                currentPixels_' . $nodeid . '[i].data[I] = originalPixels_' . $nodeid . '[i].data[I] / 255 * newColor.R;
                currentPixels_' . $nodeid . '[i].data[I + 1] = originalPixels_' . $nodeid . '[i].data[I + 1] / 255 * newColor.G;
                currentPixels_' . $nodeid . '[i].data[I + 2] = originalPixels_' . $nodeid . '[i].data[I + 2] / 255 * newColor.B;
              }
            }
            ctx_' . $nodeid . '[i].putImageData(currentPixels_' . $nodeid . '[i], 0, 0);
            img = document.getElementById("button" + i + "_' . $nodeid . '");
            img.src = canvas_' . $nodeid . '[i].toDataURL("image/png");
          }
        }
      }
      if ("' . $theme->spaceOnVid . '" == 1) {
        var video_focus;
        jQuery("#global_body_' . $nodeid . ' ,#videoID_' . $nodeid . '").each(function () {
          jQuery(this).on("click", function () {
            setTimeout("video_focus=1", 100)
          })
        })
        jQuery("body").on("click", function () {
          video_focus = 0
        })
        jQuery(window).keypress(function (event) {
          if (event.which == 13) {
            event.preventDefault();
          }
          if (event.keyCode == 32 && video_focus == 1) {
            vidOnSpace_' . $nodeid . '()
            return false;
          }
        });
      }
      function vidOnSpace_' . $nodeid . '() {
        if (video_' . $nodeid . '[0].paused) {
          video_' . $nodeid . '[0].play();
          paly_' . $nodeid . '.css("display", "none");
          pause_' . $nodeid . '.css("display", "block");
        }
        else {
          video_' . $nodeid . '[0].pause();
          paly_' . $nodeid . '.css("display", "block");
          pause_' . $nodeid . '.css("display", "none");
        }
      }
      jQuery("#track_list_' . $nodeid . '_0").find("#thumb_' . $nodeid . '_0").click();
      video_' . $nodeid . '[0].pause();
      if (paly_' . $nodeid . ' && pause_' . $nodeid . ') {
        paly_' . $nodeid . '.css("display", "block");
        pause_' . $nodeid . '.css("display", "none");
      }
      if ("' . $album_id . '" != "") {
        jQuery("#track_list_' . $nodeid . '_' . $album_id . '").find("#thumb_' . $nodeid . '_' . $track_id . '").click();
      }
      // End color.
      jQuery("#global_body_' . $nodeid . '").ready(function () {
        setTimeout("getPixels_' . $nodeid . '();changeColor_' . $nodeid . '()", 600)
      });
      jQuery(".volume_' . $nodeid . '")[0].style.width = "' . $theme->defaultVol . '%";
      video_' . $nodeid . '[0].volume=' . $theme->defaultVol / 100 . ';
    </script>
    </div>';
  if (isset($_GET['playlist']) && isset($_GET['theme'])) {
    echo $content;
  }
  else {
    return $content;
  }
}
