<?php
/**
 * @file
 *
 * Spider Video Player themes.
 */

/**
 * Menu loader callback. Load a Spider video player themes.
 */
function spider_video_player_themes() {
  $free_version = '
    <a href="http://web-dorado.com/files/fromSVPDrupal.php" target="_blank" style="color:red; text-decoration:none; float:right;">
      <img src="' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/header.png" border="0" alt="www.web-dorado.com" width="215"><br />
    <div style="float:right;">' . t('Get the full version') . '&nbsp;&nbsp;&nbsp;&nbsp;</div>
    </a>';
  $form['delete_themes'] = array(
    '#prefix' => $free_version,
    '#type' => 'submit',
    '#submit' => array('spider_video_player_delete_themes'),
    '#value' => t('Delete'),
    '#attributes' => array('onclick' => 'if (!confirm(Drupal.t("Do you want to delete selected themes?"))) {return false;}'),
  );
  $form['new_theme'] = array(
    '#prefix' => l(t('New'), url('admin/settings/spider_video_player/themes/edit', array('absolute' => TRUE))),
  );
  $header = array(
    'id' => array('data' => t('ID'), 'field' => 'n.id'),
    'title' => array('data' => t('Title'), 'field' => 'n.title'),
    'delete' => array('data' => t('Delete')),
  );
  $options = array();
  $theme_ids = db_select('spider_video_player_theme', 'n')
    ->fields('n', array('id'))
    ->extend('TableSort')
    ->orderByHeader($header)
    ->extend('PagerDefault')
    ->limit(20)
    ->execute()
    ->fetchCol();
  foreach ($theme_ids as $theme_id) {
    $row = db_query('SELECT * FROM {spider_video_player_theme} WHERE id=:id', array(':id' => $theme_id))->fetchObject();
    $options[$theme_id] = array(
      'id' => $theme_id,
      'title' => array(
        'data' => array(
          '#type' => 'link',
          '#title' => $row->title,
          '#href' => url('admin/settings/spider_video_player/themes/edit', array('query' => array('theme_id' => $theme_id), 'absolute' => TRUE)),
        ),
      ),
    );
    if ($row->default_setting != 1 ) {
      $options[$theme_id]['delete'] = array(
        'data' => array(
          '#type' => 'link',
          '#title' => t('Delete'),
          '#href' => url('admin/settings/spider_video_player/themes/delete', array('query' => array('theme_id' => $theme_id), 'absolute' => TRUE)),
        ),
      );
    }
    else {
      $options[$theme_id]['delete'] = '';
    }
  }
  $form['themes_table'] = array(
    '#type' => 'tableselect',
    '#header' => $header,
    '#options' => $options,
    '#empty' => t('No theme available.'),
    '#suffix' => theme('pager', array('tags' => array())),
  );
  foreach ($theme_ids as $theme_id) {
    if ($theme_id <= 7) {
      $form['themes_table'][$theme_id]['#disabled'] = TRUE;
    }
  }
  return $form;
}

/**
 * Delete selected themes.
 */
function spider_video_player_delete_themes($form, &$form_state) {
  if (db_query("SELECT id FROM {spider_video_player_theme}")) {
    $theme_ids_col = db_query("SELECT id FROM {spider_video_player_theme}")->fetchCol();
    $flag = FALSE;
    foreach ($theme_ids_col as $theme_id) {
      if (isset($_POST['themes_table'][$theme_id])) {
        $flag = TRUE;
        db_query("DELETE FROM {spider_video_player_theme} WHERE id=:id", array(':id' => $theme_id));
      }
    }
    if ($flag == FALSE) {
      drupal_set_message(t('You must select at least one theme.'), 'warning', FALSE);
    }
    else {
      drupal_set_message(t('Selected themes successfully deleted.'), 'status', FALSE);
    }
  }
}

/**
 * Delete theme.
 */
function spider_video_player_theme_delete() {
  if (isset($_GET['theme_id'])) {
    $theme_id = check_plain($_GET['theme_id']);
    db_query("DELETE FROM {spider_video_player_theme} WHERE id=:id", array(':id' => $theme_id));
    drupal_set_message(t('Theme successfully deleted.'), 'status', FALSE);
  }
  drupal_goto(url('admin/settings/spider_video_player/themes', array('absolute' => TRUE)));  
}

/**
 * Add or edit theme.
 */
function spider_video_player_theme_edit() {
  drupal_add_css(drupal_get_path('module', 'spider_video_player') . '/css/spider_video_player_theme.css');
  drupal_add_js(drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_change_video_type.js');
  drupal_add_js(drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_theme_reset.js');

  drupal_add_js(drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_jquery-1.7.1.js');
  drupal_add_js(drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_jquery.ui.core.js');
  drupal_add_js(drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_jquery.ui.widget.js');
  drupal_add_js(drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_jquery.ui.mouse.js');
  drupal_add_js(drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_jquery.ui.slider.js');
  drupal_add_css(drupal_get_path('module', 'spider_video_player') . '/css/spider_video_player_parseTheme.css');
  drupal_add_css(drupal_get_path('module', 'spider_video_player') . '/css/spider_video_player_jquery-ui.css');
  // drupal_add_js(drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_jquery.js');
  drupal_add_js(drupal_get_path('module', 'spider_video_player') . '/js/spider_video_player_jquery.ui.sortable.js');

  if (!file_exists("sites/all/libraries/jscolor/jscolor.js")) {
    $message = t('Download "jscolor" library from !jscolor_url and extract it to "sites/all/libraries/jscolor" directory.', array(
      '!jscolor_url' => l(t('here'), 'http://jscolor.com/release/jscolor-1.4.0.zip')));
    drupal_set_message(filter_xss($message), 'warning', FALSE);
  }
  else {
    drupal_add_js('sites/all/libraries/jscolor/jscolor.js');
  }
  if (isset($_GET['theme_id'])) {
    $theme_id = check_plain($_GET['theme_id']);
    $title = '';
  }
  else {
    $theme_id = 1;
    $title = 'new ';
  }
  $themeinf = db_query("SELECT * FROM {spider_video_player_theme} WHERE id=:id", array(':id' => $theme_id))->fetchObject();
  $title = $title . $themeinf->title;
  $app_width = $themeinf->appWidth;
  $app_height = $themeinf->appHeight;
  $playlist_width = $themeinf->playlistWidth;
  $start_with_lib = $themeinf->startWithLib;
  $auto_play = $themeinf->autoPlay;
  $auto_next = $themeinf->autoNext;
  $auto_next_album = $themeinf->autoNextAlbum;
  $default_vol = $themeinf->defaultVol;
  $default_repeat = $themeinf->defaultRepeat;
  $default_shuffle = $themeinf->defaultShuffle;
  $autohide_hime = $themeinf->autohideTime;
  $center_btn_alpha = $themeinf->centerBtnAlpha;
  $loadin_anim_type = $themeinf->loadinAnimType;
  $keep_aspect_ratio = $themeinf->keepAspectRatio;
  $click_on_vid = $themeinf->clickOnVid;
  $space_on_vid = $themeinf->spaceOnVid;
  $mouse_wheel = $themeinf->mouseWheel;
  $ctrls_pos = $themeinf->ctrlsPos;
  $ctrls_stack = $themeinf->ctrlsStack;
  $ctrls_over_vid = $themeinf->ctrlsOverVid;
  $ctrls_slide_out = $themeinf->ctrlsSlideOut;
  $watermark_url = $themeinf->watermarkUrl;
  $watermark_pos = $themeinf->watermarkPos;
  $watermark_size = $themeinf->watermarkSize;
  $watermark_spacing = $themeinf->watermarkSpacing;
  $watermark_alpha = $themeinf->watermarkAlpha;
  $playlist_pos = $themeinf->playlistPos;
  $playlist_over_vid = $themeinf->playlistOverVid;
  $playlist_auto_hide = $themeinf->playlistAutoHide;
  $playlist_text_size = $themeinf->playlistTextSize;
  $lib_cols = $themeinf->libCols;
  $lib_rows = $themeinf->libRows;
  $lib_list_text_size = $themeinf->libListTextSize;
  $lib_details_text_size = $themeinf->libDetailsTextSize;
  $app_bg_color = $themeinf->appBgColor;
  $vid_bg_color = $themeinf->vidBgColor;
  $frames_bg_color = $themeinf->framesBgColor;
  $ctrls_main_color = $themeinf->ctrlsMainColor;
  $ctrls_main_hover_color = $themeinf->ctrlsMainHoverColor;
  $slide_color = $themeinf->slideColor;
  $item_bg_hover_color = $themeinf->itemBgHoverColor;
  $item_bg_selected_color = $themeinf->itemBgSelectedColor;
  $text_color = $themeinf->textColor;
  $text_hover_color = $themeinf->textHoverColor;
  $text_selected_color = $themeinf->textSelectedColor;
  $frames_bg_alpha = $themeinf->framesBgAlpha;
  $ctrls_main_alpha = $themeinf->ctrlsMainAlpha;
  $show_trackid = $themeinf->show_trackid;
  $default = $themeinf->default_setting;
  $form = array();
  if ($default != '1' || !isset($_GET['theme_id'])) {
    $diable_title_field = FALSE;
    $themes = db_query("SELECT id,title FROM {spider_video_player_theme} WHERE default_setting=:default_setting ORDER BY title", array(':default_setting' => 1))->fetchAllKeyed();
    $themes[0] = '';
    $form['theme_select'] = array(
      '#type' => 'fieldset',
      '#attributes' => array(
        'class' => array('spider_video_player_theme_select_fieldset'),
        'id' => 'spider_video_player_theme_select_fieldset',
      ),
    );
    $form['theme_select']['default_themes'] = array(
      '#type' => 'select',
      '#title' => t('Inherit from theme'),
      '#options' => $themes,
      '#attributes' => array('onchange' => 'spider_video_player_set_theme();'),
      '#default_value' => 0,
    );
  }
  else {
    $diable_title_field = TRUE;
  }
  $form['theme_global'] = array(
    '#type' => 'fieldset',
    '#title' => t('Global Parameters'),
    '#attributes' => array(
      'class' => array('spider_video_player_theme_fieldset'),
      'id' => 'theme_global',
    ),
  );
  $form['theme_global']['theme_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Title'),
    '#required' => TRUE,
    '#default_value' => $title,
    '#disabled' => $diable_title_field,
    '#size' => 25,
  );
  $form['theme_global']['appWidth'] = array(
    '#type' => 'textfield',
    '#title' => t('Width of player'),
    '#default_value' => $app_width,
    '#size' => 25,
  );
  $form['theme_global']['appHeight'] = array(
    '#type' => 'textfield',
    '#title' => t('Height of player'),
    '#default_value' => $app_height,
    '#size' => 25,
  );
  $form['theme_global']['startWithLib'] = array(
    '#type' => 'radios',
    '#title' => t('Start with'),
    '#default_value' => $start_with_lib,
    '#options' => array('1' => t('Library'), '0' => t('Video')),
  );
  $form['theme_global']['show_trackid'] = array(
    '#type' => 'radios',
    '#title' => t('Show Track Id'),
    '#description' => t('Only for flash version'),
    '#default_value' => $show_trackid,
    '#options' => array('1' => t('Yes'), '0' => t('No')),
  );
  $form['theme_global']['autohideTime'] = array(
    '#type' => 'textfield',
    '#title' => t('Auto hide time'),
    '#default_value' => $autohide_hime,
    '#description' => t('In seconds'),
    '#size' => 25,
  );
  $form['theme_global']['keepAspectRatio'] = array(
    '#type' => 'radios',
    '#title' => t('Keep aspect ratio'),
    '#description' => t('Only for flash version'),
    '#default_value' => $keep_aspect_ratio,
    '#options' => array('1' => t('Yes'), '0' => t('No')),
  );
  $form['theme_global']['ctrlsOverVid'] = array(
    '#type' => 'radios',
    '#title' => t('Control bar over video'),
    '#description' => t('Only for flash version'),
    '#default_value' => $ctrls_over_vid,
    '#options' => array('1' => t('Yes'), '0' => t('No')),
  );
  $form['theme_global']['watermarkUrl'] = array(
    '#prefix' => '
      <div id="image_iframe" style="position:fixed; width:100%; height:100%; top:50px; left:0; display:none">
        <div id="div_black" style="position:fixed; top:0; left:0; width:100%; height:100%; background-color:#000000; opacity:0.80; z-index:10000000;"></div>
        <div id="div_content" style="position:relative; top:50px; width:570px; height:500px; margin:0 auto;z-index:10000001;background-color:#FFFFFF;">
          <iframe width="570" height="500" src="' . url('admin/settings/spider_video_player/image_upload', array('absolute' => TRUE)) . '"></iframe>
        </div>
        <div onclick=\'spider_video_player_image_upload("none")\' style=\'position:fixed; z-index:10000002; right:20%; top:100px; width:32px; height:32px; background-image:url("' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/close.png"); \'></div>
      </div>
      <strong>' . t('Watermark image') . '</strong>
      <br />',
    '#type' => 'link',
    '#href' => '',
    '#title' => t('Select Image'),
    '#attributes' => array('onclick' => 'spider_video_player_image_upload("");return false;'),
  );
  $form['theme_global']['thumb'] = array(
    '#type' => 'hidden',
    '#value' => $watermark_url,
    '#attributes' => array('id' => 'thumb'),
  );
  $form['theme_global']['playlist_thumb_remove'] = array(
    '#prefix' => '<br />',
    '#type' => 'link',
    '#href' => '',
    '#title' => t('Remove Image'),
    '#attributes' => array('onclick' => 'spider_video_player_remove_image(); return false;'),
    '#description' => t('Only for flash version'),
    '#suffix' => '<br /><img id="imagebox" ' . (($watermark_url != '') ? 'height="150" src="' . $watermark_url . '"' : '') . '/>
                  <div class="description">' . t('Only for flash version') . '</div><br />',
  );
  $form['theme_global']['watermarkPos'] = array(
    '#type' => 'radios',
    '#title' => t('Watermark Position'),
    '#description' => t('Only for flash version'),
    '#default_value' => $watermark_pos,
    '#options' => array(
      1 => t('Top left'),
      2 => t('Top right'),
      3 => t('Bottom left'),
      4 => t('Bottom right'),
    ),
  );
  $form['theme_global']['watermarkSize'] = array(
    '#type' => 'textfield',
    '#title' => t('Watermark size'),
    '#default_value' => $watermark_size,
    '#description' => t('In pixels. Only for flash version'),
    '#size' => 25,
  );
  $form['theme_global']['watermarkSpacing'] = array(
    '#type' => 'textfield',
    '#title' => t('Watermark Margin'),
    '#default_value' => $watermark_spacing,
    '#description' => t('In pixels. Only for flash version'),
    '#size' => 25,
  );
  drupal_add_js('jQuery(function() {
    spider_video_player_change_theme_slider("spider_video_player_watermarkAlpha", "slider-watermarkAlpha");
    spider_video_player_change_theme_slider("spider_video_player_centerBtnAlpha", "slider-centerBtnAlpha");
    spider_video_player_change_theme_slider("spider_video_player_framesBgAlpha", "slider-framesBgAlpha");
    spider_video_player_change_theme_slider("spider_video_player_ctrlsMainAlpha", "slider-ctrlsMainAlpha");
    spider_video_player_change_theme_slider("spider_video_player_defaultVol", "slider-defaultVol");
    });', array('type' => 'inline', 'scope' => 'footer'));
  $form['theme_global']['watermarkAlpha'] = array(
    '#prefix' => '<div style="text-align:left"><strong style="text-align:left">' . t('Watermark transparency') . '</strong></div>',
    '#type' => 'textfield',
    '#default_value' => $watermark_alpha,
    '#size' => 3,
    '#attributes' => array('id' => 'spider_video_player_watermarkAlpha'),
    '#suffix' => '% <div id="slider-watermarkAlpha" class="ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all" style="width:135px"></div>
                  <div class="description">' . t('Only for flash version') . '</div>',
  );
  if (isset($_GET['theme_id']) && $default == 1) {
    $form['theme_global']['reset_button'] = array(
      '#prefix' => '<br />
                    <div id="reset_theme_id" onclick="spider_video_player_reset_theme_' . $theme_id . '();" style="cursor:pointer; width:170px; height:35px; color:#ffffff; font-size:15px; background-repeat:no-repeat; background-image:url(\'' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/reset_theme.png\')">
                      <p style="font-weight: bold; padding-left: 51px; padding-top: 7px; margin:0px;">' . t('Reset Theme') . '</p>
                    </div>',
    );
  }
  $form['theme_style_parameters'] = array(
    '#type' => 'fieldset',
    '#title' => t('Style Parameters'),
    '#attributes' => array(
      'class' => array('spider_video_player_theme_fieldset'),
      'id' => 'theme_style_parameters',
    ),
  );
  $form['theme_style_parameters']['centerBtnAlpha'] = array(
    '#prefix' => '<div style="text-align:left"><strong style="text-align:left">' . t('Center button transparency') . '</strong></div>',
    '#type' => 'textfield',
    '#default_value' => $center_btn_alpha,
    '#size' => 3,
    '#attributes' => array('id' => 'spider_video_player_centerBtnAlpha'),
    '#suffix' => '% <div id="slider-centerBtnAlpha" class="ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all" style="width:135px"></div>
                  <div class="description">' . t('Only for flash version') . '</div>',
  );
  $form['theme_style_parameters']['appBgColor'] = array(
    '#type' => 'textfield',
    '#title' => t('Background color'),
    '#default_value' => $app_bg_color,
    '#size' => 25,
    '#attributes' => array('class' => array('color')),
  );
  $form['theme_style_parameters']['vidBgColor'] = array(
    '#type' => 'textfield',
    '#title' => t('Video background color'),
    '#default_value' => $vid_bg_color,
    '#size' => 25,
    '#attributes' => array('class' => array('color')),
  );
  $form['theme_style_parameters']['framesBgColor'] = array(
    '#type' => 'textfield',
    '#title' => t('Frames background color'),
    '#default_value' => $frames_bg_color,
    '#size' => 25,
    '#attributes' => array('class' => array('color')),
  );
  $form['theme_style_parameters']['framesBgAlpha'] = array(
    '#prefix' => '<div style="text-align:left"><strong style="text-align:left">' . t('Frames background transparency') . '</strong></div>',
    '#type' => 'textfield',
    '#default_value' => $frames_bg_alpha,
    '#size' => 3,
    '#attributes' => array('id' => 'spider_video_player_framesBgAlpha'),
    '#suffix' => '% <div id="slider-framesBgAlpha" class="ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all" style="width:135px"></div>',
  );
  $form['theme_style_parameters']['ctrlsMainColor'] = array(
    '#type' => 'textfield',
    '#title' => t('Control buttons main color'),
    '#default_value' => $ctrls_main_color,
    '#size' => 25,
    '#attributes' => array('class' => array('color')),
  );
  $form['theme_style_parameters']['ctrlsMainHoverColor'] = array(
    '#type' => 'textfield',
    '#title' => t('Control buttons hover color'),
    '#description' => t('Only for flash version'),
    '#default_value' => $ctrls_main_hover_color,
    '#size' => 25,
    '#attributes' => array('class' => array('color')),
  );
  $form['theme_style_parameters']['ctrlsMainAlpha'] = array(
    '#prefix' => '<div style="text-align:left"><strong style="text-align:left">' . t('Control buttons transparency') . '</strong></div>',
    '#type' => 'textfield',
    '#default_value' => $ctrls_main_alpha,
    '#size' => 3,
    '#attributes' => array('id' => 'spider_video_player_ctrlsMainAlpha'),
    '#suffix' => '% <div id="slider-ctrlsMainAlpha" class="ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all" style="width:135px"></div>',
  );
  $form['theme_style_parameters']['slideColor'] = array(
    '#type' => 'textfield',
    '#title' => t('Sliders color'),
    '#default_value' => $slide_color,
    '#size' => 25,
    '#attributes' => array('class' => array('color')),
  );
  $form['theme_style_parameters']['itemBgHoverColor'] = array(
    '#type' => 'textfield',
    '#title' => t('Hovered item background Color'),
    '#default_value' => $item_bg_hover_color,
    '#size' => 25,
    '#attributes' => array('class' => array('color')),
  );
  $form['theme_style_parameters']['itemBgSelectedColor'] = array(
    '#type' => 'textfield',
    '#title' => t('Selected item background Color'),
    '#default_value' => $item_bg_selected_color,
    '#size' => 25,
    '#attributes' => array('class' => array('color')),
  );
  $form['theme_style_parameters']['textColor'] = array(
    '#type' => 'textfield',
    '#title' => t('Text color'),
    '#default_value' => $text_color,
    '#size' => 25,
    '#attributes' => array('class' => array('color')),
  );
  $form['theme_style_parameters']['textHoverColor'] = array(
    '#type' => 'textfield',
    '#title' => t('Hovered text color'),
    '#default_value' => $text_hover_color,
    '#size' => 25,
    '#attributes' => array('class' => array('color')),
  );
  $form['theme_style_parameters']['textSelectedColor'] = array(
    '#type' => 'textfield',
    '#title' => t('Selected text color'),
    '#default_value' => $text_selected_color,
    '#size' => 25,
    '#attributes' => array('class' => array('color')),
  );
  $form['theme_style_parameters']['loadinAnimType'] = array(
    '#type' => 'radios',
    '#title' => t('Loading animation type'),
    '#description' => t('Only for flash version'),
    '#default_value' => $loadin_anim_type,
    '#options' => array(1 => t('Circles'), 2 => t('Lines')),
  );
  $form['theme_playback_parameters'] = array(
    '#type' => 'fieldset',
    '#title' => t('Playback Parameters'),
    '#attributes' => array(
      'class' => array('spider_video_player_theme_fieldset'),
      'id' => 'theme_playback_parameters',
    ),
  );
  $form['theme_playback_parameters']['autoPlay'] = array(
    '#type' => 'radios',
    '#title' => t('Auto play'),
    '#default_value' => $auto_play,
    '#options' => array(1 => t('Yes'), 0 => t('No')),
  );
  $form['theme_playback_parameters']['autoNext'] = array(
    '#type' => 'radios',
    '#title' => t('Auto next song'),
    '#default_value' => $auto_next,
    '#options' => array(1 => t('Yes'), 0 => t('No')),
  );
  $form['theme_playback_parameters']['autoNextAlbum'] = array(
    '#type' => 'radios',
    '#title' => t('Auto next album'),
    '#default_value' => $auto_next_album,
    '#description' => t('Only for flash version'),
    '#options' => array(1 => t('Yes'), 0 => t('No')),
  );
  $form['theme_playback_parameters']['defaultVol'] = array(
    '#prefix' => '<div style="text-align:left"><strong style="text-align:left">' . t('Default Volume') . '</strong></div>',
    '#type' => 'textfield',
    '#default_value' => $default_vol,
    '#size' => 3,
    '#attributes' => array('id' => 'spider_video_player_defaultVol'),
    '#suffix' => '% <div id="slider-defaultVol" class="ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all" style="width:135px"></div>',
  );
  $form['theme_playback_parameters']['defaultRepeat'] = array(
    '#type' => 'radios',
    '#title' => t('Repeat'),
    '#default_value' => $default_repeat,
    '#options' => array('repeatOne' => t('One'), 'repeatOff' => t('Off'), 'repeatAll' => t('All')),
  );
  $form['theme_playback_parameters']['defaultShuffle'] = array(
    '#type' => 'radios',
    '#title' => t('Shuffle'),
    '#default_value' => $default_shuffle,
    '#options' => array('shuffleOn' => t('Yes'), 'shuffleOff' => t('No')),
  );
  $form['theme_playback_parameters']['ctrlsSlideOut'] = array(
    '#type' => 'radios',
    '#title' => t('Control bar auto hide'),
    '#default_value' => $ctrls_slide_out,
    '#options' => array(1 => t('Yes'), 0 => t('No')),
  );
  $form['theme_playlist_library_parameters'] = array(
    '#type' => 'fieldset',
    '#title' => t('Playlist and Library Parameters'),
    '#attributes' => array(
      'class' => array('spider_video_player_theme_fieldset'),
      'id' => 'theme_playlist_library_parameters',
    ),
  );
  $form['theme_playlist_library_parameters']['playlistPos'] = array(
    '#type' => 'radios',
    '#title' => t('Playlist Position'),
    '#default_value' => $playlist_pos,
    '#options' => array(1 => t('Left'), 2 => t('Right')),
  );
  $form['theme_playlist_library_parameters']['playlistWidth'] = array(
    '#type' => 'textfield',
    '#title' => t('Width of playlist'),
    '#default_value' => $playlist_width,
    '#description' => t('In pixels'),
    '#size' => 25,
  );
  $form['theme_playlist_library_parameters']['playlistOverVid'] = array(
    '#type' => 'radios',
    '#title' => t('Playlist over video'),
    '#description' => t('Only for flash version'),
    '#default_value' => $playlist_over_vid,
    '#options' => array(1 => t('Yes'), 0 => t('No')),
  );
  $form['theme_playlist_library_parameters']['playlistAutoHide'] = array(
    '#type' => 'radios',
    '#title' => t('Playlist auto hide'),
    '#default_value' => $playlist_auto_hide,
    '#options' => array(1 => t('Yes'), 0 => t('No')),
  );
  $form['theme_playlist_library_parameters']['playlistTextSize'] = array(
    '#type' => 'textfield',
    '#title' => t('Playlist text size'),
    '#description' => t('In pixels'),
    '#default_value' => $playlist_text_size,
    '#size' => 25,
  );
  $form['theme_playlist_library_parameters']['libCols'] = array(
    '#type' => 'textfield',
    '#title' => t('Library colums'),
    '#default_value' => $lib_cols,
    '#size' => 25,
  );
  $form['theme_playlist_library_parameters']['libRows'] = array(
    '#type' => 'textfield',
    '#title' => t('Library rows'),
    '#default_value' => $lib_rows,
    '#size' => 25,
  );
  $form['theme_playlist_library_parameters']['libListTextSize'] = array(
    '#type' => 'textfield',
    '#title' => t('Library list text size'),
    '#description' => t('In pixels'),
    '#default_value' => $lib_list_text_size,
    '#size' => 25,
  );
  $form['theme_playlist_library_parameters']['libDetailsTextSize'] = array(
    '#type' => 'textfield',
    '#title' => t('Library details text size'),
    '#description' => t('In pixels'),
    '#default_value' => $lib_details_text_size,
    '#size' => 25,
  );
  $form['theme_video_control_parameters'] = array(
    '#type' => 'fieldset',
    '#title' => t('Video Control Parameters'),
    '#attributes' => array(
      'id' => 'theme_video_control_parameters',
    ),
  );
  $form['theme_video_control_parameters']['clickOnVid'] = array(
    '#type' => 'radios',
    '#title' => t('Play/pause on click'),
    '#default_value' => $click_on_vid,
    '#options' => array(1 => t('Yes'), 0 => t('No')),
  );
  $form['theme_video_control_parameters']['spaceOnVid'] = array(
    '#type' => 'radios',
    '#title' => t('Play/pause by space key'),
    '#default_value' => $space_on_vid,
    '#options' => array(1 => t('Yes'), 0 => t('No')),
  );
  $form['theme_video_control_parameters']['mouseWheel'] = array(
    '#type' => 'radios',
    '#title' => t('Volume control by mouse scroll'),
    '#description' => t('Only for flash version'),
    '#default_value' => $mouse_wheel,
    '#options' => array(1 => t('Yes'), 0 => t('No')),
  );
  $form['theme_video_control_parameters']['ctrlsPos'] = array(
    '#type' => 'radios',
    '#title' => t('Control bar position'),
    '#default_value' => $ctrls_pos,
    '#options' => array(1 => t('Up'), 2 => t('Down')),
  );
  $ctrls = explode(',', $ctrls_stack);
  $n = count($ctrls);
  $path = base_path() . drupal_get_path('module', 'spider_video_player') . '/images/';
  drupal_add_js('
    jQuery(document).ready(function(jQuery) {
      jQuery(document).ready(function() {
        for (var i = 0; i < ' . $n . '; i++) {
          jQuery("#arr_" + i).bind("click", {i:i}, function(event) {
            i = event.data.i;
            image = document.getElementById("arr_" + i).getAttribute("image");
            if (document.getElementById("td_arr_" + i).getAttribute("active") == 0) {
              document.getElementById("arr_" + i).src = "' . $path . '" + image + "_1.png";
              document.getElementById("td_arr_" + i).setAttribute("active", "1");
            }
            else {
              document.getElementById("arr_" + i).src="' . $path . '"+image+"_0.png";
              document.getElementById("td_arr_" + i).setAttribute("active","0");
            }
          });
        }
      });
    });
    jQuery(function() {
      jQuery("#tr_arr").sortable();
      jQuery("#tr_arr").disableSelection();
    });', array('type' => 'inline', 'scope' => 'footer'));
  $buttons_order = '
    <table border="0" bgcolor="#666666" cellpadding="0" cellspacing="0" style="width:800px !important;">
      <tr valign="top" id="tr_arr" valign="middle">';
  foreach ($ctrls as $key =>  $x) {
    $y = explode(":", $x);
    $ctrl = $y[0];
    $active = $y[1];
    $buttons_order .= '
        <td id="td_arr_' . $key . '"  active="' . $active . '" value="' . $ctrl . '" width="40" align="center" style="padding:4px">
          <img src="' . $path . $ctrl . '_' . $active . '.png" id="arr_' . $key . '" image="' . $ctrl . '" style="cursor:pointer"/>
        </td>';
  }
  $buttons_order .= '
      </tr>
    </table>';
  $form['theme_video_control_parameters']['ctrlsStack'] = array(
    '#prefix' => '<strong>' . t('Buttons order on control bar') . '</strong>',
    '#type' => 'hidden',
    '#value' => $ctrls_stack,
    '#attributes' => array('id' => 'ctrlsStack'),
    '#suffix' => $buttons_order . '<div class="description">' . t('Drag and Drop') . '</div>',
  );
  $form['theme_preview'] = array(
    '#type' => 'submit',
    '#prefix' => '<div id="preview_iframe"></div>
                  <div style="float:left; bottom:0px; clear:left;">',
    '#value' => t('Preview'),
    '#attributes' => array('onclick' => 'spider_video_player_refresh_ctrl();spider_video_player_iframe_preview("preview_iframe", "' . url('admin/settings/spider_video_player/themes/preview', array('absolute' => TRUE)) . '", "' . base_path() . drupal_get_path('module', 'spider_video_player') . '/images/close.png"); return false;'),
  );
  $form['theme_save'] = array(
    '#type' => 'submit',
    '#value' => t('Save'),
    '#submit' => array('spider_video_player_theme_save'),
    '#attributes' => array('onclick' => 'spider_video_player_refresh_ctrl();'),
  );
  $form['theme_apply'] = array(
    '#type' => 'submit',
    '#value' => t('Apply'),
    '#submit' => array('spider_video_player_theme_apply'),
    '#attributes' => array('onclick' => 'spider_video_player_refresh_ctrl();'),
  );
  $form['theme_cancel'] = array(
    '#type' => 'submit',
    '#value' => t('Cancel'),
    '#submit' => array('spider_video_player_theme_cancel'),
    '#suffix' => '</div>',
  );
  return $form;
}

/**
 * Save theme.
 */
function spider_video_player_theme_save($form, &$form_state) {
  if (isset($_GET['theme_id'])) {
    $theme_id = check_plain($_GET['theme_id']);
    db_query("UPDATE {spider_video_player_theme} SET
      title=:title,
      appWidth=:appWidth,
      appHeight=:appHeight,
      playlistWidth=:playlistWidth,
      startWithLib=:startWithLib,
      autoPlay=:autoPlay,
      autoNext=:autoNext,
      autoNextAlbum=:autoNextAlbum,
      defaultVol=:defaultVol,
      defaultRepeat=:defaultRepeat,
      defaultShuffle=:defaultShuffle,
      autohideTime=:autohideTime,
      centerBtnAlpha=:centerBtnAlpha,
      loadinAnimType=:loadinAnimType,
      keepAspectRatio=:keepAspectRatio,
      clickOnVid=:clickOnVid,
      spaceOnVid=:spaceOnVid,
      mouseWheel=:mouseWheel,
      ctrlsPos=:ctrlsPos,
      ctrlsStack=:ctrlsStack,
      ctrlsOverVid=:ctrlsOverVid,
      ctrlsSlideOut=:ctrlsSlideOut,
      watermarkUrl=:watermarkUrl,
      watermarkPos=:watermarkPos,
      watermarkSize=:watermarkSize,
      watermarkSpacing=:watermarkSpacing,
      watermarkAlpha=:watermarkAlpha,
      playlistPos=:playlistPos,
      playlistOverVid=:playlistOverVid,
      playlistAutoHide=:playlistAutoHide,
      playlistTextSize=:playlistTextSize,
      libCols=:libCols,
      libRows=:libRows,
      libListTextSize=:libListTextSize,
      libDetailsTextSize=:libDetailsTextSize,
      appBgColor=:appBgColor,
      vidBgColor=:vidBgColor,
      framesBgColor=:framesBgColor,
      ctrlsMainColor=:ctrlsMainColor,
      ctrlsMainHoverColor=:ctrlsMainHoverColor,
      slideColor=:slideColor,
      itemBgHoverColor=:itemBgHoverColor,
      itemBgSelectedColor=:itemBgSelectedColor,
      textColor=:textColor,
      textHoverColor=:textHoverColor,
      textSelectedColor=:textSelectedColor,
      framesBgAlpha=:framesBgAlpha,
      ctrlsMainAlpha=:ctrlsMainAlpha,
      show_trackid=:show_trackid
        WHERE id=:id", array(
          ':title' => $form_state['values']['theme_title'],
          ':appWidth' => $form_state['values']['appWidth'],
          ':appHeight' => $form_state['values']['appHeight'],
          ':playlistWidth' => $form_state['values']['playlistWidth'],
          ':startWithLib' => $form_state['values']['startWithLib'],
          ':autoPlay' => $form_state['values']['autoPlay'],
          ':autoNext' => $form_state['values']['autoNext'],
          ':autoNextAlbum' => $form_state['values']['autoNextAlbum'],
          ':defaultVol' => $form_state['values']['defaultVol'],
          ':defaultRepeat' => $form_state['values']['defaultRepeat'],
          ':defaultShuffle' => $form_state['values']['defaultShuffle'],
          ':autohideTime' => $form_state['values']['autohideTime'],
          ':centerBtnAlpha' => $form_state['values']['centerBtnAlpha'],
          ':loadinAnimType' => $form_state['values']['loadinAnimType'],
          ':keepAspectRatio' => $form_state['values']['keepAspectRatio'],
          ':clickOnVid' => $form_state['values']['clickOnVid'],
          ':spaceOnVid' => $form_state['values']['spaceOnVid'],
          ':mouseWheel' => $form_state['values']['mouseWheel'],
          ':ctrlsPos' => $form_state['values']['ctrlsPos'],
          ':ctrlsStack' => $_POST['ctrlsStack'],
          ':ctrlsOverVid' => $form_state['values']['ctrlsOverVid'],
          ':ctrlsSlideOut' => $form_state['values']['ctrlsSlideOut'],
          ':watermarkUrl' => check_plain($_POST['thumb']),
          ':watermarkPos' => $form_state['values']['watermarkPos'],
          ':watermarkSize' => $form_state['values']['watermarkSize'],
          ':watermarkSpacing' => $form_state['values']['watermarkSpacing'],
          ':watermarkAlpha' => $form_state['values']['watermarkAlpha'],
          ':playlistPos' => $form_state['values']['playlistPos'],
          ':playlistOverVid' => $form_state['values']['playlistOverVid'],
          ':playlistAutoHide' => $form_state['values']['playlistAutoHide'],
          ':playlistTextSize' => $form_state['values']['playlistTextSize'],
          ':libCols' => $form_state['values']['libCols'],
          ':libRows' => $form_state['values']['libRows'],
          ':libListTextSize' => $form_state['values']['libListTextSize'],
          ':libDetailsTextSize' => $form_state['values']['libDetailsTextSize'],
          ':appBgColor' => $form_state['values']['appBgColor'],
          ':vidBgColor' => $form_state['values']['vidBgColor'],
          ':framesBgColor' => $form_state['values']['framesBgColor'],
          ':ctrlsMainColor' => $form_state['values']['ctrlsMainColor'],
          ':ctrlsMainHoverColor' => $form_state['values']['ctrlsMainHoverColor'],
          ':slideColor' => $form_state['values']['slideColor'],
          ':itemBgHoverColor' => $form_state['values']['itemBgHoverColor'],
          ':itemBgSelectedColor' => $form_state['values']['itemBgSelectedColor'],
          ':textColor' => $form_state['values']['textColor'],
          ':textHoverColor' => $form_state['values']['textHoverColor'],
          ':textSelectedColor' => $form_state['values']['textSelectedColor'],
          ':framesBgAlpha' => $form_state['values']['framesBgAlpha'],
          ':ctrlsMainAlpha' => $form_state['values']['ctrlsMainAlpha'],
          ':show_trackid' => $form_state['values']['show_trackid'],
          ':id' => $theme_id,
        ));
    drupal_set_message(t('Your theme successfully updated.'), 'status', FALSE);
  }
  else {
    db_insert('spider_video_player_theme')
      ->fields(array(
        'title' => $form_state['values']['theme_title'],
        'appWidth' => $form_state['values']['appWidth'],
        'appHeight' => $form_state['values']['appHeight'],
        'playlistWidth' => $form_state['values']['playlistWidth'],
        'startWithLib' => $form_state['values']['startWithLib'],
        'autoPlay' => $form_state['values']['autoPlay'],
        'autoNext' => $form_state['values']['autoNext'],
        'autoNextAlbum' => $form_state['values']['autoNextAlbum'],
        'defaultVol' => $form_state['values']['defaultVol'],
        'defaultRepeat' => $form_state['values']['defaultRepeat'],
        'defaultShuffle' => $form_state['values']['defaultShuffle'],
        'autohideTime' => $form_state['values']['autohideTime'],
        'centerBtnAlpha' => $form_state['values']['centerBtnAlpha'],
        'loadinAnimType' => $form_state['values']['loadinAnimType'],
        'keepAspectRatio' => $form_state['values']['keepAspectRatio'],
        'clickOnVid' => $form_state['values']['clickOnVid'],
        'spaceOnVid' => $form_state['values']['spaceOnVid'],
        'mouseWheel' => $form_state['values']['mouseWheel'],
        'ctrlsPos' => $form_state['values']['ctrlsPos'],
        'ctrlsStack' => $_POST['ctrlsStack'],
        'ctrlsOverVid' => $form_state['values']['ctrlsOverVid'],
        'ctrlsSlideOut' => $form_state['values']['ctrlsSlideOut'],
        'watermarkUrl' => check_plain($_POST['thumb']),
        'watermarkPos' => $form_state['values']['watermarkPos'],
        'watermarkSize' => $form_state['values']['watermarkSize'],
        'watermarkSpacing' => $form_state['values']['watermarkSpacing'],
        'watermarkAlpha' => $form_state['values']['watermarkAlpha'],
        'playlistPos' => $form_state['values']['playlistPos'],
        'playlistOverVid' => $form_state['values']['playlistOverVid'],
        'playlistAutoHide' => $form_state['values']['playlistAutoHide'],
        'playlistTextSize' => $form_state['values']['playlistTextSize'],
        'libCols' => $form_state['values']['libCols'],
        'libRows' => $form_state['values']['libRows'],
        'libListTextSize' => $form_state['values']['libListTextSize'],
        'libDetailsTextSize' => $form_state['values']['libDetailsTextSize'],
        'appBgColor' => $form_state['values']['appBgColor'],
        'vidBgColor' => $form_state['values']['vidBgColor'],
        'framesBgColor' => $form_state['values']['framesBgColor'],
        'ctrlsMainColor' => $form_state['values']['ctrlsMainColor'],
        'ctrlsMainHoverColor' => $form_state['values']['ctrlsMainHoverColor'],
        'slideColor' => $form_state['values']['slideColor'],
        'itemBgHoverColor' => $form_state['values']['itemBgHoverColor'],
        'itemBgSelectedColor' => $form_state['values']['itemBgSelectedColor'],
        'textColor' => $form_state['values']['textColor'],
        'textHoverColor' => $form_state['values']['textHoverColor'],
        'textSelectedColor' => $form_state['values']['textSelectedColor'],
        'framesBgAlpha' => $form_state['values']['framesBgAlpha'],
        'ctrlsMainAlpha' => $form_state['values']['ctrlsMainAlpha'],
        'show_trackid' => $form_state['values']['show_trackid'],
        'default_setting' => 0,
      ))
      ->execute();
    drupal_set_message(t('Your theme successfully saved.'), 'status', FALSE);
  }
  $form_state['redirect'] = url('admin/settings/spider_video_player/themes', array('absolute' => TRUE));
}

/**
 * Apply theme.
 */
function spider_video_player_theme_apply($form, &$form_state) {
  if (isset($_GET['theme_id'])) {
    $theme_id = check_plain($_GET['theme_id']);
    db_query("UPDATE {spider_video_player_theme} SET
      title=:title,
      appWidth=:appWidth,
      appHeight=:appHeight,
      playlistWidth=:playlistWidth,
      startWithLib=:startWithLib,
      autoPlay=:autoPlay,
      autoNext=:autoNext,
      autoNextAlbum=:autoNextAlbum,
      defaultVol=:defaultVol,
      defaultRepeat=:defaultRepeat,
      defaultShuffle=:defaultShuffle,
      autohideTime=:autohideTime,
      centerBtnAlpha=:centerBtnAlpha,
      loadinAnimType=:loadinAnimType,
      keepAspectRatio=:keepAspectRatio,
      clickOnVid=:clickOnVid,
      spaceOnVid=:spaceOnVid,
      mouseWheel=:mouseWheel,
      ctrlsPos=:ctrlsPos,
      ctrlsStack=:ctrlsStack,
      ctrlsOverVid=:ctrlsOverVid,
      ctrlsSlideOut=:ctrlsSlideOut,
      watermarkUrl=:watermarkUrl,
      watermarkPos=:watermarkPos,
      watermarkSize=:watermarkSize,
      watermarkSpacing=:watermarkSpacing,
      watermarkAlpha=:watermarkAlpha,
      playlistPos=:playlistPos,
      playlistOverVid=:playlistOverVid,
      playlistAutoHide=:playlistAutoHide,
      playlistTextSize=:playlistTextSize,
      libCols=:libCols,
      libRows=:libRows,
      libListTextSize=:libListTextSize,
      libDetailsTextSize=:libDetailsTextSize,
      appBgColor=:appBgColor,
      vidBgColor=:vidBgColor,
      framesBgColor=:framesBgColor,
      ctrlsMainColor=:ctrlsMainColor,
      ctrlsMainHoverColor=:ctrlsMainHoverColor,
      slideColor=:slideColor,
      itemBgHoverColor=:itemBgHoverColor,
      itemBgSelectedColor=:itemBgSelectedColor,
      textColor=:textColor,
      textHoverColor=:textHoverColor,
      textSelectedColor=:textSelectedColor,
      framesBgAlpha=:framesBgAlpha,
      ctrlsMainAlpha=:ctrlsMainAlpha,
      show_trackid=:show_trackid
        WHERE id=:id", array(
          ':title' => $form_state['values']['theme_title'],
          ':appWidth' => $form_state['values']['appWidth'],
          ':appHeight' => $form_state['values']['appHeight'],
          ':playlistWidth' => $form_state['values']['playlistWidth'],
          ':startWithLib' => $form_state['values']['startWithLib'],
          ':autoPlay' => $form_state['values']['autoPlay'],
          ':autoNext' => $form_state['values']['autoNext'],
          ':autoNextAlbum' => $form_state['values']['autoNextAlbum'],
          ':defaultVol' => $form_state['values']['defaultVol'],
          ':defaultRepeat' => $form_state['values']['defaultRepeat'],
          ':defaultShuffle' => $form_state['values']['defaultShuffle'],
          ':autohideTime' => $form_state['values']['autohideTime'],
          ':centerBtnAlpha' => $form_state['values']['centerBtnAlpha'],
          ':loadinAnimType' => $form_state['values']['loadinAnimType'],
          ':keepAspectRatio' => $form_state['values']['keepAspectRatio'],
          ':clickOnVid' => $form_state['values']['clickOnVid'],
          ':spaceOnVid' => $form_state['values']['spaceOnVid'],
          ':mouseWheel' => $form_state['values']['mouseWheel'],
          ':ctrlsPos' => $form_state['values']['ctrlsPos'],
          ':ctrlsStack' => $_POST['ctrlsStack'],
          ':ctrlsOverVid' => $form_state['values']['ctrlsOverVid'],
          ':ctrlsSlideOut' => $form_state['values']['ctrlsSlideOut'],
          ':watermarkUrl' => check_plain($_POST['thumb']),
          ':watermarkPos' => $form_state['values']['watermarkPos'],
          ':watermarkSize' => $form_state['values']['watermarkSize'],
          ':watermarkSpacing' => $form_state['values']['watermarkSpacing'],
          ':watermarkAlpha' => $form_state['values']['watermarkAlpha'],
          ':playlistPos' => $form_state['values']['playlistPos'],
          ':playlistOverVid' => $form_state['values']['playlistOverVid'],
          ':playlistAutoHide' => $form_state['values']['playlistAutoHide'],
          ':playlistTextSize' => $form_state['values']['playlistTextSize'],
          ':libCols' => $form_state['values']['libCols'],
          ':libRows' => $form_state['values']['libRows'],
          ':libListTextSize' => $form_state['values']['libListTextSize'],
          ':libDetailsTextSize' => $form_state['values']['libDetailsTextSize'],
          ':appBgColor' => $form_state['values']['appBgColor'],
          ':vidBgColor' => $form_state['values']['vidBgColor'],
          ':framesBgColor' => $form_state['values']['framesBgColor'],
          ':ctrlsMainColor' => $form_state['values']['ctrlsMainColor'],
          ':ctrlsMainHoverColor' => $form_state['values']['ctrlsMainHoverColor'],
          ':slideColor' => $form_state['values']['slideColor'],
          ':itemBgHoverColor' => $form_state['values']['itemBgHoverColor'],
          ':itemBgSelectedColor' => $form_state['values']['itemBgSelectedColor'],
          ':textColor' => $form_state['values']['textColor'],
          ':textHoverColor' => $form_state['values']['textHoverColor'],
          ':textSelectedColor' => $form_state['values']['textSelectedColor'],
          ':framesBgAlpha' => $form_state['values']['framesBgAlpha'],
          ':ctrlsMainAlpha' => $form_state['values']['ctrlsMainAlpha'],
          ':show_trackid' => $form_state['values']['show_trackid'],
          ':id' => $theme_id,
        ));
    drupal_set_message(t('Your theme successfully updated.'), 'status', FALSE);
  }
  else {
    db_insert('spider_video_player_theme')
      ->fields(array(
        'title' => $form_state['values']['theme_title'],
        'appWidth' => $form_state['values']['appWidth'],
        'appHeight' => $form_state['values']['appHeight'],
        'playlistWidth' => $form_state['values']['playlistWidth'],
        'startWithLib' => $form_state['values']['startWithLib'],
        'autoPlay' => $form_state['values']['autoPlay'],
        'autoNext' => $form_state['values']['autoNext'],
        'autoNextAlbum' => $form_state['values']['autoNextAlbum'],
        'defaultVol' => $form_state['values']['defaultVol'],
        'defaultRepeat' => $form_state['values']['defaultRepeat'],
        'defaultShuffle' => $form_state['values']['defaultShuffle'],
        'autohideTime' => $form_state['values']['autohideTime'],
        'centerBtnAlpha' => $form_state['values']['centerBtnAlpha'],
        'loadinAnimType' => $form_state['values']['loadinAnimType'],
        'keepAspectRatio' => $form_state['values']['keepAspectRatio'],
        'clickOnVid' => $form_state['values']['clickOnVid'],
        'spaceOnVid' => $form_state['values']['spaceOnVid'],
        'mouseWheel' => $form_state['values']['mouseWheel'],
        'ctrlsPos' => $form_state['values']['ctrlsPos'],
        'ctrlsStack' => $_POST['ctrlsStack'],
        'ctrlsOverVid' => $form_state['values']['ctrlsOverVid'],
        'ctrlsSlideOut' => $form_state['values']['ctrlsSlideOut'],
        'watermarkUrl' => check_plain($_POST['thumb']),
        'watermarkPos' => $form_state['values']['watermarkPos'],
        'watermarkSize' => $form_state['values']['watermarkSize'],
        'watermarkSpacing' => $form_state['values']['watermarkSpacing'],
        'watermarkAlpha' => $form_state['values']['watermarkAlpha'],
        'playlistPos' => $form_state['values']['playlistPos'],
        'playlistOverVid' => $form_state['values']['playlistOverVid'],
        'playlistAutoHide' => $form_state['values']['playlistAutoHide'],
        'playlistTextSize' => $form_state['values']['playlistTextSize'],
        'libCols' => $form_state['values']['libCols'],
        'libRows' => $form_state['values']['libRows'],
        'libListTextSize' => $form_state['values']['libListTextSize'],
        'libDetailsTextSize' => $form_state['values']['libDetailsTextSize'],
        'appBgColor' => $form_state['values']['appBgColor'],
        'vidBgColor' => $form_state['values']['vidBgColor'],
        'framesBgColor' => $form_state['values']['framesBgColor'],
        'ctrlsMainColor' => $form_state['values']['ctrlsMainColor'],
        'ctrlsMainHoverColor' => $form_state['values']['ctrlsMainHoverColor'],
        'slideColor' => $form_state['values']['slideColor'],
        'itemBgHoverColor' => $form_state['values']['itemBgHoverColor'],
        'itemBgSelectedColor' => $form_state['values']['itemBgSelectedColor'],
        'textColor' => $form_state['values']['textColor'],
        'textHoverColor' => $form_state['values']['textHoverColor'],
        'textSelectedColor' => $form_state['values']['textSelectedColor'],
        'framesBgAlpha' => $form_state['values']['framesBgAlpha'],
        'ctrlsMainAlpha' => $form_state['values']['ctrlsMainAlpha'],
        'show_trackid' => $form_state['values']['show_trackid'],
        'default_setting' => 0,
      ))
      ->execute();
    $theme_id = db_query("SELECT MAX(id) FROM {spider_video_player_theme}")->fetchField();
    drupal_set_message(t('Your theme successfully saved.'), 'status', FALSE);
  }
  $form_state['redirect'] = url('admin/settings/spider_video_player/themes/edit', array('query' => array('theme_id' => $theme_id), 'absolute' => TRUE));
}

/**
 * Cancel theme save.
 */
function spider_video_player_theme_cancel($form, &$form_state) {
  $form_state['redirect'] = url('admin/settings/spider_video_player/themes', array('absolute' => TRUE));
}
